package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{CommitName, RepositoryName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetMergeOptionsRequest(
    repositoryName: RepositoryName,
    sourceCommitSpecifier: CommitName,
    destinationCommitSpecifier: CommitName,
    conflictDetailLevel: Optional[
      zio.aws.codecommit.model.ConflictDetailLevelTypeEnum
    ] = Optional.Absent,
    conflictResolutionStrategy: Optional[
      zio.aws.codecommit.model.ConflictResolutionStrategyTypeEnum
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.GetMergeOptionsRequest = {
    import GetMergeOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.GetMergeOptionsRequest
      .builder()
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .sourceCommitSpecifier(
        CommitName.unwrap(sourceCommitSpecifier): java.lang.String
      )
      .destinationCommitSpecifier(
        CommitName.unwrap(destinationCommitSpecifier): java.lang.String
      )
      .optionallyWith(conflictDetailLevel.map(value => value.unwrap))(
        _.conflictDetailLevel
      )
      .optionallyWith(conflictResolutionStrategy.map(value => value.unwrap))(
        _.conflictResolutionStrategy
      )
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.GetMergeOptionsRequest.ReadOnly =
    zio.aws.codecommit.model.GetMergeOptionsRequest.wrap(buildAwsValue())
}
object GetMergeOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.GetMergeOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.GetMergeOptionsRequest =
      zio.aws.codecommit.model.GetMergeOptionsRequest(
        repositoryName,
        sourceCommitSpecifier,
        destinationCommitSpecifier,
        conflictDetailLevel.map(value => value),
        conflictResolutionStrategy.map(value => value)
      )
    def repositoryName: RepositoryName
    def sourceCommitSpecifier: CommitName
    def destinationCommitSpecifier: CommitName
    def conflictDetailLevel
        : Optional[zio.aws.codecommit.model.ConflictDetailLevelTypeEnum]
    def conflictResolutionStrategy
        : Optional[zio.aws.codecommit.model.ConflictResolutionStrategyTypeEnum]
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getSourceCommitSpecifier: ZIO[Any, Nothing, CommitName] =
      ZIO.succeed(sourceCommitSpecifier)
    def getDestinationCommitSpecifier: ZIO[Any, Nothing, CommitName] =
      ZIO.succeed(destinationCommitSpecifier)
    def getConflictDetailLevel: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.ConflictDetailLevelTypeEnum
    ] = AwsError.unwrapOptionField("conflictDetailLevel", conflictDetailLevel)
    def getConflictResolutionStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.ConflictResolutionStrategyTypeEnum
    ] = AwsError.unwrapOptionField(
      "conflictResolutionStrategy",
      conflictResolutionStrategy
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.GetMergeOptionsRequest
  ) extends zio.aws.codecommit.model.GetMergeOptionsRequest.ReadOnly {
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
    override val sourceCommitSpecifier: CommitName =
      zio.aws.codecommit.model.primitives
        .CommitName(impl.sourceCommitSpecifier())
    override val destinationCommitSpecifier: CommitName =
      zio.aws.codecommit.model.primitives
        .CommitName(impl.destinationCommitSpecifier())
    override val conflictDetailLevel
        : Optional[zio.aws.codecommit.model.ConflictDetailLevelTypeEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conflictDetailLevel())
        .map(value =>
          zio.aws.codecommit.model.ConflictDetailLevelTypeEnum.wrap(value)
        )
    override val conflictResolutionStrategy: Optional[
      zio.aws.codecommit.model.ConflictResolutionStrategyTypeEnum
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.conflictResolutionStrategy())
      .map(value =>
        zio.aws.codecommit.model.ConflictResolutionStrategyTypeEnum.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.GetMergeOptionsRequest
  ): zio.aws.codecommit.model.GetMergeOptionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
