package zio.aws.codecommit.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetRepositoryResponse(
    repositoryMetadata: Optional[zio.aws.codecommit.model.RepositoryMetadata] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.GetRepositoryResponse = {
    import GetRepositoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.GetRepositoryResponse
      .builder()
      .optionallyWith(repositoryMetadata.map(value => value.buildAwsValue()))(
        _.repositoryMetadata
      )
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.GetRepositoryResponse.ReadOnly =
    zio.aws.codecommit.model.GetRepositoryResponse.wrap(buildAwsValue())
}
object GetRepositoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.GetRepositoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.GetRepositoryResponse =
      zio.aws.codecommit.model.GetRepositoryResponse(
        repositoryMetadata.map(value => value.asEditable)
      )
    def repositoryMetadata
        : Optional[zio.aws.codecommit.model.RepositoryMetadata.ReadOnly]
    def getRepositoryMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.RepositoryMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("repositoryMetadata", repositoryMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.GetRepositoryResponse
  ) extends zio.aws.codecommit.model.GetRepositoryResponse.ReadOnly {
    override val repositoryMetadata
        : Optional[zio.aws.codecommit.model.RepositoryMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.repositoryMetadata())
        .map(value => zio.aws.codecommit.model.RepositoryMetadata.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.GetRepositoryResponse
  ): zio.aws.codecommit.model.GetRepositoryResponse.ReadOnly = new Wrapper(impl)
}
