package zio.aws.codecommit.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.codecommit.model.primitives.{
  CommitName,
  NextToken,
  RepositoryName,
  Limit,
  Path
}
import scala.jdk.CollectionConverters.*
final case class ListFileCommitHistoryRequest(
    repositoryName: RepositoryName,
    commitSpecifier: Optional[CommitName] = Optional.Absent,
    filePath: Path,
    maxResults: Optional[Limit] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.ListFileCommitHistoryRequest = {
    import ListFileCommitHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.ListFileCommitHistoryRequest
      .builder()
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .optionallyWith(
        commitSpecifier.map(value => CommitName.unwrap(value): java.lang.String)
      )(_.commitSpecifier)
      .filePath(Path.unwrap(filePath): java.lang.String)
      .optionallyWith(maxResults.map(value => Limit.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.ListFileCommitHistoryRequest.ReadOnly =
    zio.aws.codecommit.model.ListFileCommitHistoryRequest.wrap(buildAwsValue())
}
object ListFileCommitHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.ListFileCommitHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.ListFileCommitHistoryRequest =
      zio.aws.codecommit.model.ListFileCommitHistoryRequest(
        repositoryName,
        commitSpecifier.map(value => value),
        filePath,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def repositoryName: RepositoryName
    def commitSpecifier: Optional[CommitName]
    def filePath: Path
    def maxResults: Optional[Limit]
    def nextToken: Optional[NextToken]
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getCommitSpecifier: ZIO[Any, AwsError, CommitName] =
      AwsError.unwrapOptionField("commitSpecifier", commitSpecifier)
    def getFilePath: ZIO[Any, Nothing, Path] = ZIO.succeed(filePath)
    def getMaxResults: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.ListFileCommitHistoryRequest
  ) extends zio.aws.codecommit.model.ListFileCommitHistoryRequest.ReadOnly {
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
    override val commitSpecifier: Optional[CommitName] = zio.aws.core.internal
      .optionalFromNullable(impl.commitSpecifier())
      .map(value => zio.aws.codecommit.model.primitives.CommitName(value))
    override val filePath: Path =
      zio.aws.codecommit.model.primitives.Path(impl.filePath())
    override val maxResults: Optional[Limit] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.codecommit.model.primitives.Limit(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codecommit.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.ListFileCommitHistoryRequest
  ): zio.aws.codecommit.model.ListFileCommitHistoryRequest.ReadOnly =
    new Wrapper(impl)
}
