package zio.aws.codecommit.model
import scala.jdk.CollectionConverters.*
sealed trait MergeOptionTypeEnum {
  def unwrap
      : software.amazon.awssdk.services.codecommit.model.MergeOptionTypeEnum
}
object MergeOptionTypeEnum {
  def wrap(
      value: software.amazon.awssdk.services.codecommit.model.MergeOptionTypeEnum
  ): zio.aws.codecommit.model.MergeOptionTypeEnum = value match {
    case software.amazon.awssdk.services.codecommit.model.MergeOptionTypeEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codecommit.model.MergeOptionTypeEnum.FAST_FORWARD_MERGE =>
      val r = FAST_FORWARD_MERGE
      r
    case software.amazon.awssdk.services.codecommit.model.MergeOptionTypeEnum.SQUASH_MERGE =>
      val r = SQUASH_MERGE
      r
    case software.amazon.awssdk.services.codecommit.model.MergeOptionTypeEnum.THREE_WAY_MERGE =>
      val r = THREE_WAY_MERGE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codecommit.model.MergeOptionTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.MergeOptionTypeEnum =
      software.amazon.awssdk.services.codecommit.model.MergeOptionTypeEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object FAST_FORWARD_MERGE
      extends zio.aws.codecommit.model.MergeOptionTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.MergeOptionTypeEnum =
      software.amazon.awssdk.services.codecommit.model.MergeOptionTypeEnum.FAST_FORWARD_MERGE
  }
  case object SQUASH_MERGE
      extends zio.aws.codecommit.model.MergeOptionTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.MergeOptionTypeEnum =
      software.amazon.awssdk.services.codecommit.model.MergeOptionTypeEnum.SQUASH_MERGE
  }
  case object THREE_WAY_MERGE
      extends zio.aws.codecommit.model.MergeOptionTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.MergeOptionTypeEnum =
      software.amazon.awssdk.services.codecommit.model.MergeOptionTypeEnum.THREE_WAY_MERGE
  }
}
