package zio.aws.codecommit.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codecommit.model.primitives.{
  RepositoryDescription,
  AccountId,
  RepositoryName,
  Arn,
  CloneUrlSsh,
  KmsKeyId,
  LastModifiedDate,
  CloneUrlHttp,
  RepositoryId,
  BranchName,
  CreationDate
}
import scala.jdk.CollectionConverters.*
final case class RepositoryMetadata(
    accountId: Optional[AccountId] = Optional.Absent,
    repositoryId: Optional[RepositoryId] = Optional.Absent,
    repositoryName: Optional[RepositoryName] = Optional.Absent,
    repositoryDescription: Optional[RepositoryDescription] = Optional.Absent,
    defaultBranch: Optional[BranchName] = Optional.Absent,
    lastModifiedDate: Optional[LastModifiedDate] = Optional.Absent,
    creationDate: Optional[CreationDate] = Optional.Absent,
    cloneUrlHttp: Optional[CloneUrlHttp] = Optional.Absent,
    cloneUrlSsh: Optional[CloneUrlSsh] = Optional.Absent,
    arn: Optional[Arn] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.RepositoryMetadata = {
    import RepositoryMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.RepositoryMetadata
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        repositoryId.map(value => RepositoryId.unwrap(value): java.lang.String)
      )(_.repositoryId)
      .optionallyWith(
        repositoryName.map(value =>
          RepositoryName.unwrap(value): java.lang.String
        )
      )(_.repositoryName)
      .optionallyWith(
        repositoryDescription.map(value =>
          RepositoryDescription.unwrap(value): java.lang.String
        )
      )(_.repositoryDescription)
      .optionallyWith(
        defaultBranch.map(value => BranchName.unwrap(value): java.lang.String)
      )(_.defaultBranch)
      .optionallyWith(
        lastModifiedDate.map(value => LastModifiedDate.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        creationDate.map(value => CreationDate.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        cloneUrlHttp.map(value => CloneUrlHttp.unwrap(value): java.lang.String)
      )(_.cloneUrlHttp)
      .optionallyWith(
        cloneUrlSsh.map(value => CloneUrlSsh.unwrap(value): java.lang.String)
      )(_.cloneUrlSsh)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.RepositoryMetadata.ReadOnly =
    zio.aws.codecommit.model.RepositoryMetadata.wrap(buildAwsValue())
}
object RepositoryMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.RepositoryMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.RepositoryMetadata =
      zio.aws.codecommit.model.RepositoryMetadata(
        accountId.map(value => value),
        repositoryId.map(value => value),
        repositoryName.map(value => value),
        repositoryDescription.map(value => value),
        defaultBranch.map(value => value),
        lastModifiedDate.map(value => value),
        creationDate.map(value => value),
        cloneUrlHttp.map(value => value),
        cloneUrlSsh.map(value => value),
        arn.map(value => value),
        kmsKeyId.map(value => value)
      )
    def accountId: Optional[AccountId]
    def repositoryId: Optional[RepositoryId]
    def repositoryName: Optional[RepositoryName]
    def repositoryDescription: Optional[RepositoryDescription]
    def defaultBranch: Optional[BranchName]
    def lastModifiedDate: Optional[LastModifiedDate]
    def creationDate: Optional[CreationDate]
    def cloneUrlHttp: Optional[CloneUrlHttp]
    def cloneUrlSsh: Optional[CloneUrlSsh]
    def arn: Optional[Arn]
    def kmsKeyId: Optional[KmsKeyId]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getRepositoryId: ZIO[Any, AwsError, RepositoryId] =
      AwsError.unwrapOptionField("repositoryId", repositoryId)
    def getRepositoryName: ZIO[Any, AwsError, RepositoryName] =
      AwsError.unwrapOptionField("repositoryName", repositoryName)
    def getRepositoryDescription: ZIO[Any, AwsError, RepositoryDescription] =
      AwsError.unwrapOptionField("repositoryDescription", repositoryDescription)
    def getDefaultBranch: ZIO[Any, AwsError, BranchName] =
      AwsError.unwrapOptionField("defaultBranch", defaultBranch)
    def getLastModifiedDate: ZIO[Any, AwsError, LastModifiedDate] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getCreationDate: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getCloneUrlHttp: ZIO[Any, AwsError, CloneUrlHttp] =
      AwsError.unwrapOptionField("cloneUrlHttp", cloneUrlHttp)
    def getCloneUrlSsh: ZIO[Any, AwsError, CloneUrlSsh] =
      AwsError.unwrapOptionField("cloneUrlSsh", cloneUrlSsh)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.RepositoryMetadata
  ) extends zio.aws.codecommit.model.RepositoryMetadata.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.codecommit.model.primitives.AccountId(value))
    override val repositoryId: Optional[RepositoryId] = zio.aws.core.internal
      .optionalFromNullable(impl.repositoryId())
      .map(value => zio.aws.codecommit.model.primitives.RepositoryId(value))
    override val repositoryName: Optional[RepositoryName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.repositoryName())
        .map(value => zio.aws.codecommit.model.primitives.RepositoryName(value))
    override val repositoryDescription: Optional[RepositoryDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.repositoryDescription())
        .map(value =>
          zio.aws.codecommit.model.primitives.RepositoryDescription(value)
        )
    override val defaultBranch: Optional[BranchName] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultBranch())
      .map(value => zio.aws.codecommit.model.primitives.BranchName(value))
    override val lastModifiedDate: Optional[LastModifiedDate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedDate())
        .map(value =>
          zio.aws.codecommit.model.primitives.LastModifiedDate(value)
        )
    override val creationDate: Optional[CreationDate] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.codecommit.model.primitives.CreationDate(value))
    override val cloneUrlHttp: Optional[CloneUrlHttp] = zio.aws.core.internal
      .optionalFromNullable(impl.cloneUrlHttp())
      .map(value => zio.aws.codecommit.model.primitives.CloneUrlHttp(value))
    override val cloneUrlSsh: Optional[CloneUrlSsh] = zio.aws.core.internal
      .optionalFromNullable(impl.cloneUrlSsh())
      .map(value => zio.aws.codecommit.model.primitives.CloneUrlSsh(value))
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.codecommit.model.primitives.Arn(value))
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.codecommit.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.RepositoryMetadata
  ): zio.aws.codecommit.model.RepositoryMetadata.ReadOnly = new Wrapper(impl)
}
