package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{KmsKeyId, RepositoryName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateRepositoryEncryptionKeyRequest(
    repositoryName: RepositoryName,
    kmsKeyId: KmsKeyId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.UpdateRepositoryEncryptionKeyRequest = {
    import UpdateRepositoryEncryptionKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.UpdateRepositoryEncryptionKeyRequest
      .builder()
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .kmsKeyId(KmsKeyId.unwrap(kmsKeyId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.UpdateRepositoryEncryptionKeyRequest.ReadOnly =
    zio.aws.codecommit.model.UpdateRepositoryEncryptionKeyRequest
      .wrap(buildAwsValue())
}
object UpdateRepositoryEncryptionKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.UpdateRepositoryEncryptionKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.UpdateRepositoryEncryptionKeyRequest =
      zio.aws.codecommit.model
        .UpdateRepositoryEncryptionKeyRequest(repositoryName, kmsKeyId)
    def repositoryName: RepositoryName
    def kmsKeyId: KmsKeyId
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getKmsKeyId: ZIO[Any, Nothing, KmsKeyId] = ZIO.succeed(kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.UpdateRepositoryEncryptionKeyRequest
  ) extends zio.aws.codecommit.model.UpdateRepositoryEncryptionKeyRequest.ReadOnly {
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
    override val kmsKeyId: KmsKeyId =
      zio.aws.codecommit.model.primitives.KmsKeyId(impl.kmsKeyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.UpdateRepositoryEncryptionKeyRequest
  ): zio.aws.codecommit.model.UpdateRepositoryEncryptionKeyRequest.ReadOnly =
    new Wrapper(impl)
}
