package zio.aws.codecommit
import zio.aws.codecommit.model.primitives.LastModifiedDate.Type
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
import zio.aws.codecommit.model.primitives.{
  RepositoryTriggerName,
  ApprovalRuleTemplateName,
  TagValue,
  RevisionId,
  Count,
  ReactionValue,
  RepositoryName,
  Arn,
  PullRequestId,
  Path,
  ObjectId,
  ApprovalRuleName,
  BranchName,
  TagKey
}
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AccountId extends zio.prelude.Subtype[String]
    type AccountId = zio.aws.codecommit.model.primitives.AccountId.Type
    object AdditionalData extends zio.prelude.Subtype[String]
    type AdditionalData =
      zio.aws.codecommit.model.primitives.AdditionalData.Type
    object ApprovalRuleContent extends zio.prelude.Subtype[String]
    type ApprovalRuleContent =
      zio.aws.codecommit.model.primitives.ApprovalRuleContent.Type
    object ApprovalRuleId extends zio.prelude.Subtype[String]
    type ApprovalRuleId =
      zio.aws.codecommit.model.primitives.ApprovalRuleId.Type
    object ApprovalRuleName extends zio.prelude.Subtype[String]
    type ApprovalRuleName =
      zio.aws.codecommit.model.primitives.ApprovalRuleName.Type
    object ApprovalRuleTemplateContent extends zio.prelude.Subtype[String]
    type ApprovalRuleTemplateContent =
      zio.aws.codecommit.model.primitives.ApprovalRuleTemplateContent.Type
    object ApprovalRuleTemplateDescription extends zio.prelude.Subtype[String]
    type ApprovalRuleTemplateDescription =
      zio.aws.codecommit.model.primitives.ApprovalRuleTemplateDescription.Type
    object ApprovalRuleTemplateId extends zio.prelude.Subtype[String]
    type ApprovalRuleTemplateId =
      zio.aws.codecommit.model.primitives.ApprovalRuleTemplateId.Type
    object ApprovalRuleTemplateName extends zio.prelude.Subtype[String]
    type ApprovalRuleTemplateName =
      zio.aws.codecommit.model.primitives.ApprovalRuleTemplateName.Type
    object Approved extends zio.prelude.Subtype[Boolean]
    type Approved = zio.aws.codecommit.model.primitives.Approved.Type
    object Arn extends zio.prelude.Subtype[String]
    type Arn = zio.aws.codecommit.model.primitives.Arn.Type
    object Blob extends zio.prelude.Subtype[Chunk[Byte]]
    type Blob = zio.aws.codecommit.model.primitives.Blob.Type
    object BranchName extends zio.prelude.Subtype[String]
    type BranchName = zio.aws.codecommit.model.primitives.BranchName.Type
    object CapitalBoolean extends zio.prelude.Subtype[Boolean]
    type CapitalBoolean =
      zio.aws.codecommit.model.primitives.CapitalBoolean.Type
    object ClientRequestToken extends zio.prelude.Subtype[String]
    type ClientRequestToken =
      zio.aws.codecommit.model.primitives.ClientRequestToken.Type
    object CloneUrlHttp extends zio.prelude.Subtype[String]
    type CloneUrlHttp = zio.aws.codecommit.model.primitives.CloneUrlHttp.Type
    object CloneUrlSsh extends zio.prelude.Subtype[String]
    type CloneUrlSsh = zio.aws.codecommit.model.primitives.CloneUrlSsh.Type
    object CommentId extends zio.prelude.Subtype[String]
    type CommentId = zio.aws.codecommit.model.primitives.CommentId.Type
    object CommitId extends zio.prelude.Subtype[String]
    type CommitId = zio.aws.codecommit.model.primitives.CommitId.Type
    object CommitName extends zio.prelude.Subtype[String]
    type CommitName = zio.aws.codecommit.model.primitives.CommitName.Type
    object Content extends zio.prelude.Subtype[String]
    type Content = zio.aws.codecommit.model.primitives.Content.Type
    object Count extends zio.prelude.Subtype[Int]
    type Count = zio.aws.codecommit.model.primitives.Count.Type
    object CreationDate extends zio.prelude.Subtype[Instant]
    type CreationDate = zio.aws.codecommit.model.primitives.CreationDate.Type
    object Date extends zio.prelude.Subtype[String]
    type Date = zio.aws.codecommit.model.primitives.Date.Type
    object Description extends zio.prelude.Subtype[String]
    type Description = zio.aws.codecommit.model.primitives.Description.Type
    object Email extends zio.prelude.Subtype[String]
    type Email = zio.aws.codecommit.model.primitives.Email.Type
    object ErrorCode extends zio.prelude.Subtype[String]
    type ErrorCode = zio.aws.codecommit.model.primitives.ErrorCode.Type
    object ErrorMessage extends zio.prelude.Subtype[String]
    type ErrorMessage = zio.aws.codecommit.model.primitives.ErrorMessage.Type
    object EventDate extends zio.prelude.Subtype[Instant]
    type EventDate = zio.aws.codecommit.model.primitives.EventDate.Type
    object ExceptionName extends zio.prelude.Subtype[String]
    type ExceptionName = zio.aws.codecommit.model.primitives.ExceptionName.Type
    object FileContent extends zio.prelude.Subtype[Chunk[Byte]]
    type FileContent = zio.aws.codecommit.model.primitives.FileContent.Type
    object FileSize extends zio.prelude.Subtype[Long]
    type FileSize = zio.aws.codecommit.model.primitives.FileSize.Type
    object HunkContent extends zio.prelude.Subtype[String]
    type HunkContent = zio.aws.codecommit.model.primitives.HunkContent.Type
    object IsCommentDeleted extends zio.prelude.Subtype[Boolean]
    type IsCommentDeleted =
      zio.aws.codecommit.model.primitives.IsCommentDeleted.Type
    object IsContentConflict extends zio.prelude.Subtype[Boolean]
    type IsContentConflict =
      zio.aws.codecommit.model.primitives.IsContentConflict.Type
    object IsFileModeConflict extends zio.prelude.Subtype[Boolean]
    type IsFileModeConflict =
      zio.aws.codecommit.model.primitives.IsFileModeConflict.Type
    object IsHunkConflict extends zio.prelude.Subtype[Boolean]
    type IsHunkConflict =
      zio.aws.codecommit.model.primitives.IsHunkConflict.Type
    object IsMergeable extends zio.prelude.Subtype[Boolean]
    type IsMergeable = zio.aws.codecommit.model.primitives.IsMergeable.Type
    object IsMerged extends zio.prelude.Subtype[Boolean]
    type IsMerged = zio.aws.codecommit.model.primitives.IsMerged.Type
    object IsMove extends zio.prelude.Subtype[Boolean]
    type IsMove = zio.aws.codecommit.model.primitives.IsMove.Type
    object IsObjectTypeConflict extends zio.prelude.Subtype[Boolean]
    type IsObjectTypeConflict =
      zio.aws.codecommit.model.primitives.IsObjectTypeConflict.Type
    object KeepEmptyFolders extends zio.prelude.Subtype[Boolean]
    type KeepEmptyFolders =
      zio.aws.codecommit.model.primitives.KeepEmptyFolders.Type
    object KmsKeyId extends zio.prelude.Subtype[String]
    type KmsKeyId = zio.aws.codecommit.model.primitives.KmsKeyId.Type
    object LastModifiedDate extends zio.prelude.Subtype[Instant]
    type LastModifiedDate =
      zio.aws.codecommit.model.primitives.LastModifiedDate.Type
    object Limit extends zio.prelude.Subtype[Int]
    type Limit = zio.aws.codecommit.model.primitives.Limit.Type
    object LineNumber extends zio.prelude.Subtype[Int]
    type LineNumber = zio.aws.codecommit.model.primitives.LineNumber.Type
    object MaxResults extends zio.prelude.Subtype[Int]
    type MaxResults = zio.aws.codecommit.model.primitives.MaxResults.Type
    object Message extends zio.prelude.Subtype[String]
    type Message = zio.aws.codecommit.model.primitives.Message.Type
    object Mode extends zio.prelude.Subtype[String]
    type Mode = zio.aws.codecommit.model.primitives.Mode.Type
    object Name extends zio.prelude.Subtype[String]
    type Name = zio.aws.codecommit.model.primitives.Name.Type
    object NextToken extends zio.prelude.Subtype[String]
    type NextToken = zio.aws.codecommit.model.primitives.NextToken.Type
    object NumberOfConflicts extends zio.prelude.Subtype[Int]
    type NumberOfConflicts =
      zio.aws.codecommit.model.primitives.NumberOfConflicts.Type
    object ObjectId extends zio.prelude.Subtype[String]
    type ObjectId = zio.aws.codecommit.model.primitives.ObjectId.Type
    object ObjectSize extends zio.prelude.Subtype[Long]
    type ObjectSize = zio.aws.codecommit.model.primitives.ObjectSize.Type
    object Overridden extends zio.prelude.Subtype[Boolean]
    type Overridden = zio.aws.codecommit.model.primitives.Overridden.Type
    object Path extends zio.prelude.Subtype[String]
    type Path = zio.aws.codecommit.model.primitives.Path.Type
    object Position extends zio.prelude.Subtype[Long]
    type Position = zio.aws.codecommit.model.primitives.Position.Type
    object PullRequestId extends zio.prelude.Subtype[String]
    type PullRequestId = zio.aws.codecommit.model.primitives.PullRequestId.Type
    object ReactionEmoji extends zio.prelude.Subtype[String]
    type ReactionEmoji = zio.aws.codecommit.model.primitives.ReactionEmoji.Type
    object ReactionShortCode extends zio.prelude.Subtype[String]
    type ReactionShortCode =
      zio.aws.codecommit.model.primitives.ReactionShortCode.Type
    object ReactionUnicode extends zio.prelude.Subtype[String]
    type ReactionUnicode =
      zio.aws.codecommit.model.primitives.ReactionUnicode.Type
    object ReactionValue extends zio.prelude.Subtype[String]
    type ReactionValue = zio.aws.codecommit.model.primitives.ReactionValue.Type
    object ReferenceName extends zio.prelude.Subtype[String]
    type ReferenceName = zio.aws.codecommit.model.primitives.ReferenceName.Type
    object RepositoryDescription extends zio.prelude.Subtype[String]
    type RepositoryDescription =
      zio.aws.codecommit.model.primitives.RepositoryDescription.Type
    object RepositoryId extends zio.prelude.Subtype[String]
    type RepositoryId = zio.aws.codecommit.model.primitives.RepositoryId.Type
    object RepositoryName extends zio.prelude.Subtype[String]
    type RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName.Type
    object RepositoryTriggerCustomData extends zio.prelude.Subtype[String]
    type RepositoryTriggerCustomData =
      zio.aws.codecommit.model.primitives.RepositoryTriggerCustomData.Type
    object RepositoryTriggerExecutionFailureMessage
        extends zio.prelude.Subtype[String]
    type RepositoryTriggerExecutionFailureMessage =
      zio.aws.codecommit.model.primitives.RepositoryTriggerExecutionFailureMessage.Type
    object RepositoryTriggerName extends zio.prelude.Subtype[String]
    type RepositoryTriggerName =
      zio.aws.codecommit.model.primitives.RepositoryTriggerName.Type
    object RepositoryTriggersConfigurationId extends zio.prelude.Subtype[String]
    type RepositoryTriggersConfigurationId =
      zio.aws.codecommit.model.primitives.RepositoryTriggersConfigurationId.Type
    object ResourceArn extends zio.prelude.Subtype[String]
    type ResourceArn = zio.aws.codecommit.model.primitives.ResourceArn.Type
    object RevisionId extends zio.prelude.Subtype[String]
    type RevisionId = zio.aws.codecommit.model.primitives.RevisionId.Type
    object RuleContentSha256 extends zio.prelude.Subtype[String]
    type RuleContentSha256 =
      zio.aws.codecommit.model.primitives.RuleContentSha256.Type
    object TagKey extends zio.prelude.Subtype[String]
    type TagKey = zio.aws.codecommit.model.primitives.TagKey.Type
    object TagValue extends zio.prelude.Subtype[String]
    type TagValue = zio.aws.codecommit.model.primitives.TagValue.Type
    object Title extends zio.prelude.Subtype[String]
    type Title = zio.aws.codecommit.model.primitives.Title.Type
  }
  type ApprovalList = List[zio.aws.codecommit.model.Approval]
  type ApprovalRuleTemplateNameList = List[ApprovalRuleTemplateName]
  type ApprovalRulesList = List[zio.aws.codecommit.model.ApprovalRule]
  type ApprovalRulesNotSatisfiedList = List[ApprovalRuleName]
  type ApprovalRulesSatisfiedList = List[ApprovalRuleName]
  type BatchAssociateApprovalRuleTemplateWithRepositoriesErrorsList = List[
    zio.aws.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesError
  ]
  type BatchDescribeMergeConflictsErrors =
    List[zio.aws.codecommit.model.BatchDescribeMergeConflictsError]
  type BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorsList = List[
    zio.aws.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesError
  ]
  type BatchGetCommitsErrorsList =
    List[zio.aws.codecommit.model.BatchGetCommitsError]
  type BatchGetRepositoriesErrorsList =
    List[zio.aws.codecommit.model.BatchGetRepositoriesError]
  type BranchNameList = List[BranchName]
  type CallerReactions = List[ReactionValue]
  type Comments = List[zio.aws.codecommit.model.Comment]
  type CommentsForComparedCommitData =
    List[zio.aws.codecommit.model.CommentsForComparedCommit]
  type CommentsForPullRequestData =
    List[zio.aws.codecommit.model.CommentsForPullRequest]
  type CommitIdsInputList = List[ObjectId]
  type CommitObjectsList = List[zio.aws.codecommit.model.Commit]
  type ConflictMetadataList = List[zio.aws.codecommit.model.ConflictMetadata]
  type Conflicts = List[zio.aws.codecommit.model.Conflict]
  type DeleteFileEntries = List[zio.aws.codecommit.model.DeleteFileEntry]
  type DifferenceList = List[zio.aws.codecommit.model.Difference]
  type FileList = List[zio.aws.codecommit.model.File]
  type FilePaths = List[Path]
  type FilesMetadata = List[zio.aws.codecommit.model.FileMetadata]
  type FolderList = List[zio.aws.codecommit.model.Folder]
  type MergeHunks = List[zio.aws.codecommit.model.MergeHunk]
  type MergeOptions = List[zio.aws.codecommit.model.MergeOptionTypeEnum]
  type ParentList = List[ObjectId]
  type PullRequestEventList = List[zio.aws.codecommit.model.PullRequestEvent]
  type PullRequestIdList = List[PullRequestId]
  type PullRequestTargetList = List[zio.aws.codecommit.model.PullRequestTarget]
  type PutFileEntries = List[zio.aws.codecommit.model.PutFileEntry]
  type ReactionCountsMap = Map[ReactionValue, Count]
  type ReactionUsersList = List[Arn]
  type ReactionsForCommentList =
    List[zio.aws.codecommit.model.ReactionForComment]
  type ReplaceContentEntries =
    List[zio.aws.codecommit.model.ReplaceContentEntry]
  type RepositoryMetadataList =
    List[zio.aws.codecommit.model.RepositoryMetadata]
  type RepositoryNameIdPairList =
    List[zio.aws.codecommit.model.RepositoryNameIdPair]
  type RepositoryNameList = List[RepositoryName]
  type RepositoryNotFoundList = List[RepositoryName]
  type RepositoryTriggerEventList =
    List[zio.aws.codecommit.model.RepositoryTriggerEventEnum]
  type RepositoryTriggerExecutionFailureList =
    List[zio.aws.codecommit.model.RepositoryTriggerExecutionFailure]
  type RepositoryTriggerNameList = List[RepositoryTriggerName]
  type RepositoryTriggersList = List[zio.aws.codecommit.model.RepositoryTrigger]
  type RevisionChildren = List[RevisionId]
  type RevisionDag = List[zio.aws.codecommit.model.FileVersion]
  type SetFileModeEntries = List[zio.aws.codecommit.model.SetFileModeEntry]
  type SubModuleList = List[zio.aws.codecommit.model.SubModule]
  type SymbolicLinkList = List[zio.aws.codecommit.model.SymbolicLink]
  type TagKeysList = List[TagKey]
  type TagsMap = Map[TagKey, TagValue]
  type TargetList = List[zio.aws.codecommit.model.Target]
}
