package zio.aws.codecommit.model
import scala.jdk.CollectionConverters.*
sealed trait ApprovalState {
  def unwrap: software.amazon.awssdk.services.codecommit.model.ApprovalState
}
object ApprovalState {
  def wrap(
      value: software.amazon.awssdk.services.codecommit.model.ApprovalState
  ): zio.aws.codecommit.model.ApprovalState = value match {
    case software.amazon.awssdk.services.codecommit.model.ApprovalState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codecommit.model.ApprovalState.APPROVE =>
      val r = APPROVE
      r
    case software.amazon.awssdk.services.codecommit.model.ApprovalState.REVOKE =>
      val r = REVOKE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codecommit.model.ApprovalState {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.ApprovalState =
      software.amazon.awssdk.services.codecommit.model.ApprovalState.UNKNOWN_TO_SDK_VERSION
  }
  case object APPROVE extends zio.aws.codecommit.model.ApprovalState {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.ApprovalState =
      software.amazon.awssdk.services.codecommit.model.ApprovalState.APPROVE
  }
  case object REVOKE extends zio.aws.codecommit.model.ApprovalState {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.ApprovalState =
      software.amazon.awssdk.services.codecommit.model.ApprovalState.REVOKE
  }
}
