package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.RepositoryName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchAssociateApprovalRuleTemplateWithRepositoriesResponse(
    associatedRepositoryNames: Iterable[RepositoryName],
    errors: Iterable[
      zio.aws.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesError
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesResponse = {
    import BatchAssociateApprovalRuleTemplateWithRepositoriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesResponse
      .builder()
      .associatedRepositoryNames(associatedRepositoryNames.map { item =>
        RepositoryName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .errors(errors.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesResponse.ReadOnly =
    zio.aws.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesResponse
      .wrap(buildAwsValue())
}
object BatchAssociateApprovalRuleTemplateWithRepositoriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesResponse =
      zio.aws.codecommit.model
        .BatchAssociateApprovalRuleTemplateWithRepositoriesResponse(
          associatedRepositoryNames,
          errors.map { item =>
            item.asEditable
          }
        )
    def associatedRepositoryNames: List[RepositoryName]
    def errors: List[
      zio.aws.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesError.ReadOnly
    ]
    def getAssociatedRepositoryNames: ZIO[Any, Nothing, List[RepositoryName]] =
      ZIO.succeed(associatedRepositoryNames)
    def getErrors: ZIO[Any, Nothing, List[
      zio.aws.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesError.ReadOnly
    ]] = ZIO.succeed(errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesResponse
  ) extends zio.aws.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesResponse.ReadOnly {
    override val associatedRepositoryNames: List[RepositoryName] = impl
      .associatedRepositoryNames()
      .asScala
      .map { item =>
        zio.aws.codecommit.model.primitives.RepositoryName(item)
      }
      .toList
    override val errors: List[
      zio.aws.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesError.ReadOnly
    ] = impl
      .errors()
      .asScala
      .map { item =>
        zio.aws.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesError
          .wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesResponse
  ): zio.aws.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesResponse.ReadOnly =
    new Wrapper(impl)
}
