package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  ErrorMessage,
  RepositoryName,
  RepositoryId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchGetRepositoriesError(
    repositoryId: Optional[RepositoryId] = Optional.Absent,
    repositoryName: Optional[RepositoryName] = Optional.Absent,
    errorCode: Optional[
      zio.aws.codecommit.model.BatchGetRepositoriesErrorCodeEnum
    ] = Optional.Absent,
    errorMessage: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesError = {
    import BatchGetRepositoriesError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesError
      .builder()
      .optionallyWith(
        repositoryId.map(value => RepositoryId.unwrap(value): java.lang.String)
      )(_.repositoryId)
      .optionallyWith(
        repositoryName.map(value =>
          RepositoryName.unwrap(value): java.lang.String
        )
      )(_.repositoryName)
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.BatchGetRepositoriesError.ReadOnly =
    zio.aws.codecommit.model.BatchGetRepositoriesError.wrap(buildAwsValue())
}
object BatchGetRepositoriesError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.BatchGetRepositoriesError =
      zio.aws.codecommit.model.BatchGetRepositoriesError(
        repositoryId.map(value => value),
        repositoryName.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def repositoryId: Optional[RepositoryId]
    def repositoryName: Optional[RepositoryName]
    def errorCode
        : Optional[zio.aws.codecommit.model.BatchGetRepositoriesErrorCodeEnum]
    def errorMessage: Optional[ErrorMessage]
    def getRepositoryId: ZIO[Any, AwsError, RepositoryId] =
      AwsError.unwrapOptionField("repositoryId", repositoryId)
    def getRepositoryName: ZIO[Any, AwsError, RepositoryName] =
      AwsError.unwrapOptionField("repositoryName", repositoryName)
    def getErrorCode: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.BatchGetRepositoriesErrorCodeEnum
    ] = AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesError
  ) extends zio.aws.codecommit.model.BatchGetRepositoriesError.ReadOnly {
    override val repositoryId: Optional[RepositoryId] = zio.aws.core.internal
      .optionalFromNullable(impl.repositoryId())
      .map(value => zio.aws.codecommit.model.primitives.RepositoryId(value))
    override val repositoryName: Optional[RepositoryName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.repositoryName())
        .map(value => zio.aws.codecommit.model.primitives.RepositoryName(value))
    override val errorCode
        : Optional[zio.aws.codecommit.model.BatchGetRepositoriesErrorCodeEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorCode())
        .map(value =>
          zio.aws.codecommit.model.BatchGetRepositoriesErrorCodeEnum.wrap(value)
        )
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.codecommit.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesError
  ): zio.aws.codecommit.model.BatchGetRepositoriesError.ReadOnly = new Wrapper(
    impl
  )
}
