package zio.aws.codecommit.model
import scala.jdk.CollectionConverters.*
sealed trait BatchGetRepositoriesErrorCodeEnum {
  def unwrap: software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesErrorCodeEnum
}
object BatchGetRepositoriesErrorCodeEnum {
  def wrap(
      value: software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesErrorCodeEnum
  ): zio.aws.codecommit.model.BatchGetRepositoriesErrorCodeEnum = value match {
    case software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesErrorCodeEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesErrorCodeEnum.ENCRYPTION_INTEGRITY_CHECKS_FAILED_EXCEPTION =>
      val r = EncryptionIntegrityChecksFailedException
      r
    case software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesErrorCodeEnum.ENCRYPTION_KEY_ACCESS_DENIED_EXCEPTION =>
      val r = EncryptionKeyAccessDeniedException
      r
    case software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesErrorCodeEnum.ENCRYPTION_KEY_DISABLED_EXCEPTION =>
      val r = EncryptionKeyDisabledException
      r
    case software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesErrorCodeEnum.ENCRYPTION_KEY_NOT_FOUND_EXCEPTION =>
      val r = EncryptionKeyNotFoundException
      r
    case software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesErrorCodeEnum.ENCRYPTION_KEY_UNAVAILABLE_EXCEPTION =>
      val r = EncryptionKeyUnavailableException
      r
    case software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesErrorCodeEnum.REPOSITORY_DOES_NOT_EXIST_EXCEPTION =>
      val r = RepositoryDoesNotExistException
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codecommit.model.BatchGetRepositoriesErrorCodeEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesErrorCodeEnum =
      software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesErrorCodeEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object EncryptionIntegrityChecksFailedException
      extends zio.aws.codecommit.model.BatchGetRepositoriesErrorCodeEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesErrorCodeEnum =
      software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesErrorCodeEnum.ENCRYPTION_INTEGRITY_CHECKS_FAILED_EXCEPTION
  }
  case object EncryptionKeyAccessDeniedException
      extends zio.aws.codecommit.model.BatchGetRepositoriesErrorCodeEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesErrorCodeEnum =
      software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesErrorCodeEnum.ENCRYPTION_KEY_ACCESS_DENIED_EXCEPTION
  }
  case object EncryptionKeyDisabledException
      extends zio.aws.codecommit.model.BatchGetRepositoriesErrorCodeEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesErrorCodeEnum =
      software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesErrorCodeEnum.ENCRYPTION_KEY_DISABLED_EXCEPTION
  }
  case object EncryptionKeyNotFoundException
      extends zio.aws.codecommit.model.BatchGetRepositoriesErrorCodeEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesErrorCodeEnum =
      software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesErrorCodeEnum.ENCRYPTION_KEY_NOT_FOUND_EXCEPTION
  }
  case object EncryptionKeyUnavailableException
      extends zio.aws.codecommit.model.BatchGetRepositoriesErrorCodeEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesErrorCodeEnum =
      software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesErrorCodeEnum.ENCRYPTION_KEY_UNAVAILABLE_EXCEPTION
  }
  case object RepositoryDoesNotExistException
      extends zio.aws.codecommit.model.BatchGetRepositoriesErrorCodeEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesErrorCodeEnum =
      software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesErrorCodeEnum.REPOSITORY_DOES_NOT_EXIST_EXCEPTION
  }
}
