package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  RepositoryDescription,
  TagValue,
  RepositoryName,
  KmsKeyId,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateRepositoryRequest(
    repositoryName: RepositoryName,
    repositoryDescription: Optional[RepositoryDescription] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.CreateRepositoryRequest = {
    import CreateRepositoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.CreateRepositoryRequest
      .builder()
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .optionallyWith(
        repositoryDescription.map(value =>
          RepositoryDescription.unwrap(value): java.lang.String
        )
      )(_.repositoryDescription)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.CreateRepositoryRequest.ReadOnly =
    zio.aws.codecommit.model.CreateRepositoryRequest.wrap(buildAwsValue())
}
object CreateRepositoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.CreateRepositoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.CreateRepositoryRequest =
      zio.aws.codecommit.model.CreateRepositoryRequest(
        repositoryName,
        repositoryDescription.map(value => value),
        tags.map(value => value),
        kmsKeyId.map(value => value)
      )
    def repositoryName: RepositoryName
    def repositoryDescription: Optional[RepositoryDescription]
    def tags: Optional[Map[TagKey, TagValue]]
    def kmsKeyId: Optional[KmsKeyId]
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getRepositoryDescription: ZIO[Any, AwsError, RepositoryDescription] =
      AwsError.unwrapOptionField("repositoryDescription", repositoryDescription)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.CreateRepositoryRequest
  ) extends zio.aws.codecommit.model.CreateRepositoryRequest.ReadOnly {
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
    override val repositoryDescription: Optional[RepositoryDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.repositoryDescription())
        .map(value =>
          zio.aws.codecommit.model.primitives.RepositoryDescription(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.codecommit.model.primitives.TagKey(
              key
            ) -> zio.aws.codecommit.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.codecommit.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.CreateRepositoryRequest
  ): zio.aws.codecommit.model.CreateRepositoryRequest.ReadOnly = new Wrapper(
    impl
  )
}
