package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{RevisionId, PullRequestId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetPullRequestApprovalStatesRequest(
    pullRequestId: PullRequestId,
    revisionId: RevisionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.GetPullRequestApprovalStatesRequest = {
    import GetPullRequestApprovalStatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.GetPullRequestApprovalStatesRequest
      .builder()
      .pullRequestId(PullRequestId.unwrap(pullRequestId): java.lang.String)
      .revisionId(RevisionId.unwrap(revisionId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.GetPullRequestApprovalStatesRequest.ReadOnly =
    zio.aws.codecommit.model.GetPullRequestApprovalStatesRequest
      .wrap(buildAwsValue())
}
object GetPullRequestApprovalStatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.GetPullRequestApprovalStatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.GetPullRequestApprovalStatesRequest =
      zio.aws.codecommit.model
        .GetPullRequestApprovalStatesRequest(pullRequestId, revisionId)
    def pullRequestId: PullRequestId
    def revisionId: RevisionId
    def getPullRequestId: ZIO[Any, Nothing, PullRequestId] =
      ZIO.succeed(pullRequestId)
    def getRevisionId: ZIO[Any, Nothing, RevisionId] = ZIO.succeed(revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.GetPullRequestApprovalStatesRequest
  ) extends zio.aws.codecommit.model.GetPullRequestApprovalStatesRequest.ReadOnly {
    override val pullRequestId: PullRequestId =
      zio.aws.codecommit.model.primitives.PullRequestId(impl.pullRequestId())
    override val revisionId: RevisionId =
      zio.aws.codecommit.model.primitives.RevisionId(impl.revisionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.GetPullRequestApprovalStatesRequest
  ): zio.aws.codecommit.model.GetPullRequestApprovalStatesRequest.ReadOnly =
    new Wrapper(impl)
}
