package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{BranchName, RepositoryName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateDefaultBranchRequest(
    repositoryName: RepositoryName,
    defaultBranchName: BranchName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.UpdateDefaultBranchRequest = {
    import UpdateDefaultBranchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.UpdateDefaultBranchRequest
      .builder()
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .defaultBranchName(BranchName.unwrap(defaultBranchName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.UpdateDefaultBranchRequest.ReadOnly =
    zio.aws.codecommit.model.UpdateDefaultBranchRequest.wrap(buildAwsValue())
}
object UpdateDefaultBranchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.UpdateDefaultBranchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.UpdateDefaultBranchRequest =
      zio.aws.codecommit.model
        .UpdateDefaultBranchRequest(repositoryName, defaultBranchName)
    def repositoryName: RepositoryName
    def defaultBranchName: BranchName
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getDefaultBranchName: ZIO[Any, Nothing, BranchName] =
      ZIO.succeed(defaultBranchName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.UpdateDefaultBranchRequest
  ) extends zio.aws.codecommit.model.UpdateDefaultBranchRequest.ReadOnly {
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
    override val defaultBranchName: BranchName =
      zio.aws.codecommit.model.primitives.BranchName(impl.defaultBranchName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.UpdateDefaultBranchRequest
  ): zio.aws.codecommit.model.UpdateDefaultBranchRequest.ReadOnly = new Wrapper(
    impl
  )
}
