package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  ApprovalRuleContent,
  RuleContentSha256,
  ApprovalRuleName,
  PullRequestId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdatePullRequestApprovalRuleContentRequest(
    pullRequestId: PullRequestId,
    approvalRuleName: ApprovalRuleName,
    existingRuleContentSha256: Optional[RuleContentSha256] = Optional.Absent,
    newRuleContent: ApprovalRuleContent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.UpdatePullRequestApprovalRuleContentRequest = {
    import UpdatePullRequestApprovalRuleContentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.UpdatePullRequestApprovalRuleContentRequest
      .builder()
      .pullRequestId(PullRequestId.unwrap(pullRequestId): java.lang.String)
      .approvalRuleName(
        ApprovalRuleName.unwrap(approvalRuleName): java.lang.String
      )
      .optionallyWith(
        existingRuleContentSha256.map(value =>
          RuleContentSha256.unwrap(value): java.lang.String
        )
      )(_.existingRuleContentSha256)
      .newRuleContent(
        ApprovalRuleContent.unwrap(newRuleContent): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.UpdatePullRequestApprovalRuleContentRequest.ReadOnly =
    zio.aws.codecommit.model.UpdatePullRequestApprovalRuleContentRequest
      .wrap(buildAwsValue())
}
object UpdatePullRequestApprovalRuleContentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.UpdatePullRequestApprovalRuleContentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.UpdatePullRequestApprovalRuleContentRequest =
      zio.aws.codecommit.model.UpdatePullRequestApprovalRuleContentRequest(
        pullRequestId,
        approvalRuleName,
        existingRuleContentSha256.map(value => value),
        newRuleContent
      )
    def pullRequestId: PullRequestId
    def approvalRuleName: ApprovalRuleName
    def existingRuleContentSha256: Optional[RuleContentSha256]
    def newRuleContent: ApprovalRuleContent
    def getPullRequestId: ZIO[Any, Nothing, PullRequestId] =
      ZIO.succeed(pullRequestId)
    def getApprovalRuleName: ZIO[Any, Nothing, ApprovalRuleName] =
      ZIO.succeed(approvalRuleName)
    def getExistingRuleContentSha256: ZIO[Any, AwsError, RuleContentSha256] =
      AwsError.unwrapOptionField(
        "existingRuleContentSha256",
        existingRuleContentSha256
      )
    def getNewRuleContent: ZIO[Any, Nothing, ApprovalRuleContent] =
      ZIO.succeed(newRuleContent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.UpdatePullRequestApprovalRuleContentRequest
  ) extends zio.aws.codecommit.model.UpdatePullRequestApprovalRuleContentRequest.ReadOnly {
    override val pullRequestId: PullRequestId =
      zio.aws.codecommit.model.primitives.PullRequestId(impl.pullRequestId())
    override val approvalRuleName: ApprovalRuleName =
      zio.aws.codecommit.model.primitives
        .ApprovalRuleName(impl.approvalRuleName())
    override val existingRuleContentSha256: Optional[RuleContentSha256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.existingRuleContentSha256())
        .map(value =>
          zio.aws.codecommit.model.primitives.RuleContentSha256(value)
        )
    override val newRuleContent: ApprovalRuleContent =
      zio.aws.codecommit.model.primitives
        .ApprovalRuleContent(impl.newRuleContent())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.UpdatePullRequestApprovalRuleContentRequest
  ): zio.aws.codecommit.model.UpdatePullRequestApprovalRuleContentRequest.ReadOnly =
    new Wrapper(impl)
}
