package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{RevisionId, PullRequestId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdatePullRequestApprovalStateRequest(
    pullRequestId: PullRequestId,
    revisionId: RevisionId,
    approvalState: zio.aws.codecommit.model.ApprovalState
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.UpdatePullRequestApprovalStateRequest = {
    import UpdatePullRequestApprovalStateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.UpdatePullRequestApprovalStateRequest
      .builder()
      .pullRequestId(PullRequestId.unwrap(pullRequestId): java.lang.String)
      .revisionId(RevisionId.unwrap(revisionId): java.lang.String)
      .approvalState(approvalState.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.UpdatePullRequestApprovalStateRequest.ReadOnly =
    zio.aws.codecommit.model.UpdatePullRequestApprovalStateRequest
      .wrap(buildAwsValue())
}
object UpdatePullRequestApprovalStateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.UpdatePullRequestApprovalStateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.UpdatePullRequestApprovalStateRequest =
      zio.aws.codecommit.model.UpdatePullRequestApprovalStateRequest(
        pullRequestId,
        revisionId,
        approvalState
      )
    def pullRequestId: PullRequestId
    def revisionId: RevisionId
    def approvalState: zio.aws.codecommit.model.ApprovalState
    def getPullRequestId: ZIO[Any, Nothing, PullRequestId] =
      ZIO.succeed(pullRequestId)
    def getRevisionId: ZIO[Any, Nothing, RevisionId] = ZIO.succeed(revisionId)
    def getApprovalState
        : ZIO[Any, Nothing, zio.aws.codecommit.model.ApprovalState] =
      ZIO.succeed(approvalState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.UpdatePullRequestApprovalStateRequest
  ) extends zio.aws.codecommit.model.UpdatePullRequestApprovalStateRequest.ReadOnly {
    override val pullRequestId: PullRequestId =
      zio.aws.codecommit.model.primitives.PullRequestId(impl.pullRequestId())
    override val revisionId: RevisionId =
      zio.aws.codecommit.model.primitives.RevisionId(impl.revisionId())
    override val approvalState: zio.aws.codecommit.model.ApprovalState =
      zio.aws.codecommit.model.ApprovalState.wrap(impl.approvalState())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.UpdatePullRequestApprovalStateRequest
  ): zio.aws.codecommit.model.UpdatePullRequestApprovalStateRequest.ReadOnly =
    new Wrapper(impl)
}
