package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{KmsKeyId, RepositoryId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateRepositoryEncryptionKeyResponse(
    repositoryId: Optional[RepositoryId] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    originalKmsKeyId: Optional[KmsKeyId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.UpdateRepositoryEncryptionKeyResponse = {
    import UpdateRepositoryEncryptionKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.UpdateRepositoryEncryptionKeyResponse
      .builder()
      .optionallyWith(
        repositoryId.map(value => RepositoryId.unwrap(value): java.lang.String)
      )(_.repositoryId)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        originalKmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.originalKmsKeyId)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.UpdateRepositoryEncryptionKeyResponse.ReadOnly =
    zio.aws.codecommit.model.UpdateRepositoryEncryptionKeyResponse
      .wrap(buildAwsValue())
}
object UpdateRepositoryEncryptionKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.UpdateRepositoryEncryptionKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.UpdateRepositoryEncryptionKeyResponse =
      zio.aws.codecommit.model.UpdateRepositoryEncryptionKeyResponse(
        repositoryId.map(value => value),
        kmsKeyId.map(value => value),
        originalKmsKeyId.map(value => value)
      )
    def repositoryId: Optional[RepositoryId]
    def kmsKeyId: Optional[KmsKeyId]
    def originalKmsKeyId: Optional[KmsKeyId]
    def getRepositoryId: ZIO[Any, AwsError, RepositoryId] =
      AwsError.unwrapOptionField("repositoryId", repositoryId)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getOriginalKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("originalKmsKeyId", originalKmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.UpdateRepositoryEncryptionKeyResponse
  ) extends zio.aws.codecommit.model.UpdateRepositoryEncryptionKeyResponse.ReadOnly {
    override val repositoryId: Optional[RepositoryId] = zio.aws.core.internal
      .optionalFromNullable(impl.repositoryId())
      .map(value => zio.aws.codecommit.model.primitives.RepositoryId(value))
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.codecommit.model.primitives.KmsKeyId(value))
    override val originalKmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.originalKmsKeyId())
      .map(value => zio.aws.codecommit.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.UpdateRepositoryEncryptionKeyResponse
  ): zio.aws.codecommit.model.UpdateRepositoryEncryptionKeyResponse.ReadOnly =
    new Wrapper(impl)
}
