package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{ErrorMessage, ApplicationName}
import scala.jdk.CollectionConverters.*
final case class BatchGetApplicationRevisionsResponse(
    applicationName: Option[ApplicationName] = None,
    errorMessage: Option[ErrorMessage] = None,
    revisions: Option[Iterable[zio.aws.codedeploy.model.RevisionInfo]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationRevisionsResponse = {
    import BatchGetApplicationRevisionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationRevisionsResponse
      .builder()
      .optionallyWith(
        applicationName.map(value =>
          ApplicationName.unwrap(value): java.lang.String
        )
      )(_.applicationName)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .optionallyWith(
        revisions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.revisions)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.BatchGetApplicationRevisionsResponse.ReadOnly =
    zio.aws.codedeploy.model.BatchGetApplicationRevisionsResponse
      .wrap(buildAwsValue())
}
object BatchGetApplicationRevisionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationRevisionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codedeploy.model.BatchGetApplicationRevisionsResponse =
      zio.aws.codedeploy.model.BatchGetApplicationRevisionsResponse(
        applicationName.map(value => value),
        errorMessage.map(value => value),
        revisions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def applicationName: Option[ApplicationName]
    def errorMessage: Option[ErrorMessage]
    def revisions: Option[List[zio.aws.codedeploy.model.RevisionInfo.ReadOnly]]
    def getApplicationName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("applicationName", applicationName)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getRevisions: ZIO[Any, AwsError, List[
      zio.aws.codedeploy.model.RevisionInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("revisions", revisions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationRevisionsResponse
  ) extends zio.aws.codedeploy.model.BatchGetApplicationRevisionsResponse.ReadOnly {
    override val applicationName: Option[ApplicationName] = scala
      .Option(impl.applicationName())
      .map(value => zio.aws.codedeploy.model.primitives.ApplicationName(value))
    override val errorMessage: Option[ErrorMessage] = scala
      .Option(impl.errorMessage())
      .map(value => zio.aws.codedeploy.model.primitives.ErrorMessage(value))
    override val revisions
        : Option[List[zio.aws.codedeploy.model.RevisionInfo.ReadOnly]] = scala
      .Option(impl.revisions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codedeploy.model.RevisionInfo.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationRevisionsResponse
  ): zio.aws.codedeploy.model.BatchGetApplicationRevisionsResponse.ReadOnly =
    new Wrapper(impl)
}
