package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codedeploy.model.primitives.{
  DeploymentGroupName,
  ApplicationName
}
import scala.jdk.CollectionConverters.*
final case class BatchGetDeploymentGroupsRequest(
    applicationName: ApplicationName,
    deploymentGroupNames: Iterable[DeploymentGroupName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentGroupsRequest = {
    import BatchGetDeploymentGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentGroupsRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .deploymentGroupNames(deploymentGroupNames.map { item =>
        DeploymentGroupName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.BatchGetDeploymentGroupsRequest.ReadOnly =
    zio.aws.codedeploy.model.BatchGetDeploymentGroupsRequest
      .wrap(buildAwsValue())
}
object BatchGetDeploymentGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.BatchGetDeploymentGroupsRequest =
      zio.aws.codedeploy.model
        .BatchGetDeploymentGroupsRequest(applicationName, deploymentGroupNames)
    def applicationName: ApplicationName
    def deploymentGroupNames: List[DeploymentGroupName]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getDeploymentGroupNames: ZIO[Any, Nothing, List[DeploymentGroupName]] =
      ZIO.succeed(deploymentGroupNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentGroupsRequest
  ) extends zio.aws.codedeploy.model.BatchGetDeploymentGroupsRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.codedeploy.model.primitives
        .ApplicationName(impl.applicationName())
    override val deploymentGroupNames: List[DeploymentGroupName] = impl
      .deploymentGroupNames()
      .asScala
      .map { item =>
        zio.aws.codedeploy.model.primitives.DeploymentGroupName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentGroupsRequest
  ): zio.aws.codedeploy.model.BatchGetDeploymentGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
