package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codedeploy.model.primitives.DeploymentId
import scala.jdk.CollectionConverters.*
final case class BatchGetDeploymentsRequest(
    deploymentIds: Iterable[DeploymentId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentsRequest = {
    import BatchGetDeploymentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentsRequest
      .builder()
      .deploymentIds(deploymentIds.map { item =>
        DeploymentId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.BatchGetDeploymentsRequest.ReadOnly =
    zio.aws.codedeploy.model.BatchGetDeploymentsRequest.wrap(buildAwsValue())
}
object BatchGetDeploymentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.BatchGetDeploymentsRequest =
      zio.aws.codedeploy.model.BatchGetDeploymentsRequest(deploymentIds)
    def deploymentIds: List[DeploymentId]
    def getDeploymentIds: ZIO[Any, Nothing, List[DeploymentId]] =
      ZIO.succeed(deploymentIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentsRequest
  ) extends zio.aws.codedeploy.model.BatchGetDeploymentsRequest.ReadOnly {
    override val deploymentIds: List[DeploymentId] = impl
      .deploymentIds()
      .asScala
      .map { item =>
        zio.aws.codedeploy.model.primitives.DeploymentId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentsRequest
  ): zio.aws.codedeploy.model.BatchGetDeploymentsRequest.ReadOnly = new Wrapper(
    impl
  )
}
