package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BatchGetDeploymentsResponse(
    deploymentsInfo: Option[Iterable[zio.aws.codedeploy.model.DeploymentInfo]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentsResponse = {
    import BatchGetDeploymentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentsResponse
      .builder()
      .optionallyWith(
        deploymentsInfo.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deploymentsInfo)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.BatchGetDeploymentsResponse.ReadOnly =
    zio.aws.codedeploy.model.BatchGetDeploymentsResponse.wrap(buildAwsValue())
}
object BatchGetDeploymentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.BatchGetDeploymentsResponse =
      zio.aws.codedeploy.model.BatchGetDeploymentsResponse(
        deploymentsInfo.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def deploymentsInfo
        : Option[List[zio.aws.codedeploy.model.DeploymentInfo.ReadOnly]]
    def getDeploymentsInfo: ZIO[Any, AwsError, List[
      zio.aws.codedeploy.model.DeploymentInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("deploymentsInfo", deploymentsInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentsResponse
  ) extends zio.aws.codedeploy.model.BatchGetDeploymentsResponse.ReadOnly {
    override val deploymentsInfo
        : Option[List[zio.aws.codedeploy.model.DeploymentInfo.ReadOnly]] = scala
      .Option(impl.deploymentsInfo())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codedeploy.model.DeploymentInfo.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentsResponse
  ): zio.aws.codedeploy.model.BatchGetDeploymentsResponse.ReadOnly =
    new Wrapper(impl)
}
