package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{
  Description,
  DeploymentConfigName,
  DeploymentGroupName,
  ApplicationName
}
import scala.jdk.CollectionConverters.*
final case class CreateDeploymentRequest(
    applicationName: ApplicationName,
    deploymentGroupName: Option[DeploymentGroupName] = None,
    revision: Option[zio.aws.codedeploy.model.RevisionLocation] = None,
    deploymentConfigName: Option[DeploymentConfigName] = None,
    description: Option[Description] = None,
    ignoreApplicationStopFailures: Option[Boolean] = None,
    targetInstances: Option[zio.aws.codedeploy.model.TargetInstances] = None,
    autoRollbackConfiguration: Option[
      zio.aws.codedeploy.model.AutoRollbackConfiguration
    ] = None,
    updateOutdatedInstancesOnly: Option[Boolean] = None,
    fileExistsBehavior: Option[zio.aws.codedeploy.model.FileExistsBehavior] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.CreateDeploymentRequest = {
    import CreateDeploymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.CreateDeploymentRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .optionallyWith(
        deploymentGroupName.map(value =>
          DeploymentGroupName.unwrap(value): java.lang.String
        )
      )(_.deploymentGroupName)
      .optionallyWith(revision.map(value => value.buildAwsValue()))(_.revision)
      .optionallyWith(
        deploymentConfigName.map(value =>
          DeploymentConfigName.unwrap(value): java.lang.String
        )
      )(_.deploymentConfigName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        ignoreApplicationStopFailures.map(value => value: java.lang.Boolean)
      )(_.ignoreApplicationStopFailures)
      .optionallyWith(targetInstances.map(value => value.buildAwsValue()))(
        _.targetInstances
      )
      .optionallyWith(
        autoRollbackConfiguration.map(value => value.buildAwsValue())
      )(_.autoRollbackConfiguration)
      .optionallyWith(
        updateOutdatedInstancesOnly.map(value => value: java.lang.Boolean)
      )(_.updateOutdatedInstancesOnly)
      .optionallyWith(fileExistsBehavior.map(value => value.unwrap))(
        _.fileExistsBehavior
      )
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.CreateDeploymentRequest.ReadOnly =
    zio.aws.codedeploy.model.CreateDeploymentRequest.wrap(buildAwsValue())
}
object CreateDeploymentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.CreateDeploymentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.CreateDeploymentRequest =
      zio.aws.codedeploy.model.CreateDeploymentRequest(
        applicationName,
        deploymentGroupName.map(value => value),
        revision.map(value => value.asEditable),
        deploymentConfigName.map(value => value),
        description.map(value => value),
        ignoreApplicationStopFailures.map(value => value),
        targetInstances.map(value => value.asEditable),
        autoRollbackConfiguration.map(value => value.asEditable),
        updateOutdatedInstancesOnly.map(value => value),
        fileExistsBehavior.map(value => value)
      )
    def applicationName: ApplicationName
    def deploymentGroupName: Option[DeploymentGroupName]
    def revision: Option[zio.aws.codedeploy.model.RevisionLocation.ReadOnly]
    def deploymentConfigName: Option[DeploymentConfigName]
    def description: Option[Description]
    def ignoreApplicationStopFailures: Option[Boolean]
    def targetInstances
        : Option[zio.aws.codedeploy.model.TargetInstances.ReadOnly]
    def autoRollbackConfiguration
        : Option[zio.aws.codedeploy.model.AutoRollbackConfiguration.ReadOnly]
    def updateOutdatedInstancesOnly: Option[Boolean]
    def fileExistsBehavior: Option[zio.aws.codedeploy.model.FileExistsBehavior]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getDeploymentGroupName: ZIO[Any, AwsError, DeploymentGroupName] =
      AwsError.unwrapOptionField("deploymentGroupName", deploymentGroupName)
    def getRevision: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.RevisionLocation.ReadOnly
    ] = AwsError.unwrapOptionField("revision", revision)
    def getDeploymentConfigName: ZIO[Any, AwsError, DeploymentConfigName] =
      AwsError.unwrapOptionField("deploymentConfigName", deploymentConfigName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getIgnoreApplicationStopFailures: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "ignoreApplicationStopFailures",
        ignoreApplicationStopFailures
      )
    def getTargetInstances: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.TargetInstances.ReadOnly
    ] = AwsError.unwrapOptionField("targetInstances", targetInstances)
    def getAutoRollbackConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.AutoRollbackConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "autoRollbackConfiguration",
      autoRollbackConfiguration
    )
    def getUpdateOutdatedInstancesOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "updateOutdatedInstancesOnly",
        updateOutdatedInstancesOnly
      )
    def getFileExistsBehavior
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.FileExistsBehavior] =
      AwsError.unwrapOptionField("fileExistsBehavior", fileExistsBehavior)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.CreateDeploymentRequest
  ) extends zio.aws.codedeploy.model.CreateDeploymentRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.codedeploy.model.primitives
        .ApplicationName(impl.applicationName())
    override val deploymentGroupName: Option[DeploymentGroupName] = scala
      .Option(impl.deploymentGroupName())
      .map(value =>
        zio.aws.codedeploy.model.primitives.DeploymentGroupName(value)
      )
    override val revision
        : Option[zio.aws.codedeploy.model.RevisionLocation.ReadOnly] = scala
      .Option(impl.revision())
      .map(value => zio.aws.codedeploy.model.RevisionLocation.wrap(value))
    override val deploymentConfigName: Option[DeploymentConfigName] = scala
      .Option(impl.deploymentConfigName())
      .map(value =>
        zio.aws.codedeploy.model.primitives.DeploymentConfigName(value)
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.codedeploy.model.primitives.Description(value))
    override val ignoreApplicationStopFailures: Option[Boolean] = scala
      .Option(impl.ignoreApplicationStopFailures())
      .map(value => value: Boolean)
    override val targetInstances
        : Option[zio.aws.codedeploy.model.TargetInstances.ReadOnly] = scala
      .Option(impl.targetInstances())
      .map(value => zio.aws.codedeploy.model.TargetInstances.wrap(value))
    override val autoRollbackConfiguration
        : Option[zio.aws.codedeploy.model.AutoRollbackConfiguration.ReadOnly] =
      scala
        .Option(impl.autoRollbackConfiguration())
        .map(value =>
          zio.aws.codedeploy.model.AutoRollbackConfiguration.wrap(value)
        )
    override val updateOutdatedInstancesOnly: Option[Boolean] = scala
      .Option(impl.updateOutdatedInstancesOnly())
      .map(value => value: Boolean)
    override val fileExistsBehavior
        : Option[zio.aws.codedeploy.model.FileExistsBehavior] = scala
      .Option(impl.fileExistsBehavior())
      .map(value => zio.aws.codedeploy.model.FileExistsBehavior.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.CreateDeploymentRequest
  ): zio.aws.codedeploy.model.CreateDeploymentRequest.ReadOnly = new Wrapper(
    impl
  )
}
