package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codedeploy.model.primitives.ApplicationName
import scala.jdk.CollectionConverters.*
final case class DeleteApplicationRequest(applicationName: ApplicationName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.DeleteApplicationRequest = {
    import DeleteApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.DeleteApplicationRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.DeleteApplicationRequest.ReadOnly =
    zio.aws.codedeploy.model.DeleteApplicationRequest.wrap(buildAwsValue())
}
object DeleteApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.DeleteApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.DeleteApplicationRequest =
      zio.aws.codedeploy.model.DeleteApplicationRequest(applicationName)
    def applicationName: ApplicationName
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.DeleteApplicationRequest
  ) extends zio.aws.codedeploy.model.DeleteApplicationRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.codedeploy.model.primitives
        .ApplicationName(impl.applicationName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.DeleteApplicationRequest
  ): zio.aws.codedeploy.model.DeleteApplicationRequest.ReadOnly = new Wrapper(
    impl
  )
}
