package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codedeploy.model.primitives.DeploymentConfigName
import scala.jdk.CollectionConverters.*
final case class DeleteDeploymentConfigRequest(
    deploymentConfigName: DeploymentConfigName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentConfigRequest = {
    import DeleteDeploymentConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentConfigRequest
      .builder()
      .deploymentConfigName(
        DeploymentConfigName.unwrap(deploymentConfigName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.DeleteDeploymentConfigRequest.ReadOnly =
    zio.aws.codedeploy.model.DeleteDeploymentConfigRequest.wrap(buildAwsValue())
}
object DeleteDeploymentConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.DeleteDeploymentConfigRequest =
      zio.aws.codedeploy.model
        .DeleteDeploymentConfigRequest(deploymentConfigName)
    def deploymentConfigName: DeploymentConfigName
    def getDeploymentConfigName: ZIO[Any, Nothing, DeploymentConfigName] =
      ZIO.succeed(deploymentConfigName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentConfigRequest
  ) extends zio.aws.codedeploy.model.DeleteDeploymentConfigRequest.ReadOnly {
    override val deploymentConfigName: DeploymentConfigName =
      zio.aws.codedeploy.model.primitives
        .DeploymentConfigName(impl.deploymentConfigName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentConfigRequest
  ): zio.aws.codedeploy.model.DeleteDeploymentConfigRequest.ReadOnly =
    new Wrapper(impl)
}
