package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteDeploymentGroupResponse(
    hooksNotCleanedUp: Option[
      Iterable[zio.aws.codedeploy.model.AutoScalingGroup]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentGroupResponse = {
    import DeleteDeploymentGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentGroupResponse
      .builder()
      .optionallyWith(
        hooksNotCleanedUp.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hooksNotCleanedUp)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.DeleteDeploymentGroupResponse.ReadOnly =
    zio.aws.codedeploy.model.DeleteDeploymentGroupResponse.wrap(buildAwsValue())
}
object DeleteDeploymentGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.DeleteDeploymentGroupResponse =
      zio.aws.codedeploy.model.DeleteDeploymentGroupResponse(
        hooksNotCleanedUp.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def hooksNotCleanedUp
        : Option[List[zio.aws.codedeploy.model.AutoScalingGroup.ReadOnly]]
    def getHooksNotCleanedUp: ZIO[Any, AwsError, List[
      zio.aws.codedeploy.model.AutoScalingGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("hooksNotCleanedUp", hooksNotCleanedUp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentGroupResponse
  ) extends zio.aws.codedeploy.model.DeleteDeploymentGroupResponse.ReadOnly {
    override val hooksNotCleanedUp
        : Option[List[zio.aws.codedeploy.model.AutoScalingGroup.ReadOnly]] =
      scala
        .Option(impl.hooksNotCleanedUp())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.AutoScalingGroup.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentGroupResponse
  ): zio.aws.codedeploy.model.DeleteDeploymentGroupResponse.ReadOnly =
    new Wrapper(impl)
}
