package zio.aws.codedeploy.model
import scala.jdk.CollectionConverters.*
sealed trait DeploymentCreator {
  def unwrap: software.amazon.awssdk.services.codedeploy.model.DeploymentCreator
}
object DeploymentCreator {
  def wrap(
      value: software.amazon.awssdk.services.codedeploy.model.DeploymentCreator
  ): zio.aws.codedeploy.model.DeploymentCreator = value match {
    case software.amazon.awssdk.services.codedeploy.model.DeploymentCreator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codedeploy.model.DeploymentCreator.USER =>
      val r = user
      r
    case software.amazon.awssdk.services.codedeploy.model.DeploymentCreator.AUTOSCALING =>
      val r = autoscaling
      r
    case software.amazon.awssdk.services.codedeploy.model.DeploymentCreator.CODE_DEPLOY_ROLLBACK =>
      val r = codeDeployRollback
      r
    case software.amazon.awssdk.services.codedeploy.model.DeploymentCreator.CODE_DEPLOY =>
      val r = CodeDeploy
      r
    case software.amazon.awssdk.services.codedeploy.model.DeploymentCreator.CODE_DEPLOY_AUTO_UPDATE =>
      val r = CodeDeployAutoUpdate
      r
    case software.amazon.awssdk.services.codedeploy.model.DeploymentCreator.CLOUD_FORMATION =>
      val r = CloudFormation
      r
    case software.amazon.awssdk.services.codedeploy.model.DeploymentCreator.CLOUD_FORMATION_ROLLBACK =>
      val r = CloudFormationRollback
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codedeploy.model.DeploymentCreator {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.DeploymentCreator =
      software.amazon.awssdk.services.codedeploy.model.DeploymentCreator.UNKNOWN_TO_SDK_VERSION
  }
  case object user extends zio.aws.codedeploy.model.DeploymentCreator {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.DeploymentCreator =
      software.amazon.awssdk.services.codedeploy.model.DeploymentCreator.USER
  }
  case object autoscaling extends zio.aws.codedeploy.model.DeploymentCreator {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.DeploymentCreator =
      software.amazon.awssdk.services.codedeploy.model.DeploymentCreator.AUTOSCALING
  }
  case object codeDeployRollback
      extends zio.aws.codedeploy.model.DeploymentCreator {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.DeploymentCreator =
      software.amazon.awssdk.services.codedeploy.model.DeploymentCreator.CODE_DEPLOY_ROLLBACK
  }
  case object CodeDeploy extends zio.aws.codedeploy.model.DeploymentCreator {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.DeploymentCreator =
      software.amazon.awssdk.services.codedeploy.model.DeploymentCreator.CODE_DEPLOY
  }
  case object CodeDeployAutoUpdate
      extends zio.aws.codedeploy.model.DeploymentCreator {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.DeploymentCreator =
      software.amazon.awssdk.services.codedeploy.model.DeploymentCreator.CODE_DEPLOY_AUTO_UPDATE
  }
  case object CloudFormation
      extends zio.aws.codedeploy.model.DeploymentCreator {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.DeploymentCreator =
      software.amazon.awssdk.services.codedeploy.model.DeploymentCreator.CLOUD_FORMATION
  }
  case object CloudFormationRollback
      extends zio.aws.codedeploy.model.DeploymentCreator {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.DeploymentCreator =
      software.amazon.awssdk.services.codedeploy.model.DeploymentCreator.CLOUD_FORMATION_ROLLBACK
  }
}
