package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{
  DeploymentGroupId,
  DeploymentGroupName,
  DeploymentConfigName,
  ApplicationName,
  Role
}
import scala.jdk.CollectionConverters.*
final case class DeploymentGroupInfo(
    applicationName: Option[ApplicationName] = None,
    deploymentGroupId: Option[DeploymentGroupId] = None,
    deploymentGroupName: Option[DeploymentGroupName] = None,
    deploymentConfigName: Option[DeploymentConfigName] = None,
    ec2TagFilters: Option[Iterable[zio.aws.codedeploy.model.EC2TagFilter]] =
      None,
    onPremisesInstanceTagFilters: Option[
      Iterable[zio.aws.codedeploy.model.TagFilter]
    ] = None,
    autoScalingGroups: Option[
      Iterable[zio.aws.codedeploy.model.AutoScalingGroup]
    ] = None,
    serviceRoleArn: Option[Role] = None,
    targetRevision: Option[zio.aws.codedeploy.model.RevisionLocation] = None,
    triggerConfigurations: Option[
      Iterable[zio.aws.codedeploy.model.TriggerConfig]
    ] = None,
    alarmConfiguration: Option[zio.aws.codedeploy.model.AlarmConfiguration] =
      None,
    autoRollbackConfiguration: Option[
      zio.aws.codedeploy.model.AutoRollbackConfiguration
    ] = None,
    deploymentStyle: Option[zio.aws.codedeploy.model.DeploymentStyle] = None,
    outdatedInstancesStrategy: Option[
      zio.aws.codedeploy.model.OutdatedInstancesStrategy
    ] = None,
    blueGreenDeploymentConfiguration: Option[
      zio.aws.codedeploy.model.BlueGreenDeploymentConfiguration
    ] = None,
    loadBalancerInfo: Option[zio.aws.codedeploy.model.LoadBalancerInfo] = None,
    lastSuccessfulDeployment: Option[
      zio.aws.codedeploy.model.LastDeploymentInfo
    ] = None,
    lastAttemptedDeployment: Option[
      zio.aws.codedeploy.model.LastDeploymentInfo
    ] = None,
    ec2TagSet: Option[zio.aws.codedeploy.model.EC2TagSet] = None,
    onPremisesTagSet: Option[zio.aws.codedeploy.model.OnPremisesTagSet] = None,
    computePlatform: Option[zio.aws.codedeploy.model.ComputePlatform] = None,
    ecsServices: Option[Iterable[zio.aws.codedeploy.model.ECSService]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.DeploymentGroupInfo = {
    import DeploymentGroupInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.DeploymentGroupInfo
      .builder()
      .optionallyWith(
        applicationName.map(value =>
          ApplicationName.unwrap(value): java.lang.String
        )
      )(_.applicationName)
      .optionallyWith(
        deploymentGroupId.map(value =>
          DeploymentGroupId.unwrap(value): java.lang.String
        )
      )(_.deploymentGroupId)
      .optionallyWith(
        deploymentGroupName.map(value =>
          DeploymentGroupName.unwrap(value): java.lang.String
        )
      )(_.deploymentGroupName)
      .optionallyWith(
        deploymentConfigName.map(value =>
          DeploymentConfigName.unwrap(value): java.lang.String
        )
      )(_.deploymentConfigName)
      .optionallyWith(
        ec2TagFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ec2TagFilters)
      .optionallyWith(
        onPremisesInstanceTagFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.onPremisesInstanceTagFilters)
      .optionallyWith(
        autoScalingGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.autoScalingGroups)
      .optionallyWith(
        serviceRoleArn.map(value => Role.unwrap(value): java.lang.String)
      )(_.serviceRoleArn)
      .optionallyWith(targetRevision.map(value => value.buildAwsValue()))(
        _.targetRevision
      )
      .optionallyWith(
        triggerConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.triggerConfigurations)
      .optionallyWith(alarmConfiguration.map(value => value.buildAwsValue()))(
        _.alarmConfiguration
      )
      .optionallyWith(
        autoRollbackConfiguration.map(value => value.buildAwsValue())
      )(_.autoRollbackConfiguration)
      .optionallyWith(deploymentStyle.map(value => value.buildAwsValue()))(
        _.deploymentStyle
      )
      .optionallyWith(outdatedInstancesStrategy.map(value => value.unwrap))(
        _.outdatedInstancesStrategy
      )
      .optionallyWith(
        blueGreenDeploymentConfiguration.map(value => value.buildAwsValue())
      )(_.blueGreenDeploymentConfiguration)
      .optionallyWith(loadBalancerInfo.map(value => value.buildAwsValue()))(
        _.loadBalancerInfo
      )
      .optionallyWith(
        lastSuccessfulDeployment.map(value => value.buildAwsValue())
      )(_.lastSuccessfulDeployment)
      .optionallyWith(
        lastAttemptedDeployment.map(value => value.buildAwsValue())
      )(_.lastAttemptedDeployment)
      .optionallyWith(ec2TagSet.map(value => value.buildAwsValue()))(
        _.ec2TagSet
      )
      .optionallyWith(onPremisesTagSet.map(value => value.buildAwsValue()))(
        _.onPremisesTagSet
      )
      .optionallyWith(computePlatform.map(value => value.unwrap))(
        _.computePlatform
      )
      .optionallyWith(
        ecsServices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ecsServices)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.DeploymentGroupInfo.ReadOnly =
    zio.aws.codedeploy.model.DeploymentGroupInfo.wrap(buildAwsValue())
}
object DeploymentGroupInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.DeploymentGroupInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.DeploymentGroupInfo =
      zio.aws.codedeploy.model.DeploymentGroupInfo(
        applicationName.map(value => value),
        deploymentGroupId.map(value => value),
        deploymentGroupName.map(value => value),
        deploymentConfigName.map(value => value),
        ec2TagFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        onPremisesInstanceTagFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        autoScalingGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        serviceRoleArn.map(value => value),
        targetRevision.map(value => value.asEditable),
        triggerConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        alarmConfiguration.map(value => value.asEditable),
        autoRollbackConfiguration.map(value => value.asEditable),
        deploymentStyle.map(value => value.asEditable),
        outdatedInstancesStrategy.map(value => value),
        blueGreenDeploymentConfiguration.map(value => value.asEditable),
        loadBalancerInfo.map(value => value.asEditable),
        lastSuccessfulDeployment.map(value => value.asEditable),
        lastAttemptedDeployment.map(value => value.asEditable),
        ec2TagSet.map(value => value.asEditable),
        onPremisesTagSet.map(value => value.asEditable),
        computePlatform.map(value => value),
        ecsServices.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def applicationName: Option[ApplicationName]
    def deploymentGroupId: Option[DeploymentGroupId]
    def deploymentGroupName: Option[DeploymentGroupName]
    def deploymentConfigName: Option[DeploymentConfigName]
    def ec2TagFilters
        : Option[List[zio.aws.codedeploy.model.EC2TagFilter.ReadOnly]]
    def onPremisesInstanceTagFilters
        : Option[List[zio.aws.codedeploy.model.TagFilter.ReadOnly]]
    def autoScalingGroups
        : Option[List[zio.aws.codedeploy.model.AutoScalingGroup.ReadOnly]]
    def serviceRoleArn: Option[Role]
    def targetRevision
        : Option[zio.aws.codedeploy.model.RevisionLocation.ReadOnly]
    def triggerConfigurations
        : Option[List[zio.aws.codedeploy.model.TriggerConfig.ReadOnly]]
    def alarmConfiguration
        : Option[zio.aws.codedeploy.model.AlarmConfiguration.ReadOnly]
    def autoRollbackConfiguration
        : Option[zio.aws.codedeploy.model.AutoRollbackConfiguration.ReadOnly]
    def deploymentStyle
        : Option[zio.aws.codedeploy.model.DeploymentStyle.ReadOnly]
    def outdatedInstancesStrategy
        : Option[zio.aws.codedeploy.model.OutdatedInstancesStrategy]
    def blueGreenDeploymentConfiguration: Option[
      zio.aws.codedeploy.model.BlueGreenDeploymentConfiguration.ReadOnly
    ]
    def loadBalancerInfo
        : Option[zio.aws.codedeploy.model.LoadBalancerInfo.ReadOnly]
    def lastSuccessfulDeployment
        : Option[zio.aws.codedeploy.model.LastDeploymentInfo.ReadOnly]
    def lastAttemptedDeployment
        : Option[zio.aws.codedeploy.model.LastDeploymentInfo.ReadOnly]
    def ec2TagSet: Option[zio.aws.codedeploy.model.EC2TagSet.ReadOnly]
    def onPremisesTagSet
        : Option[zio.aws.codedeploy.model.OnPremisesTagSet.ReadOnly]
    def computePlatform: Option[zio.aws.codedeploy.model.ComputePlatform]
    def ecsServices: Option[List[zio.aws.codedeploy.model.ECSService.ReadOnly]]
    def getApplicationName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("applicationName", applicationName)
    def getDeploymentGroupId: ZIO[Any, AwsError, DeploymentGroupId] =
      AwsError.unwrapOptionField("deploymentGroupId", deploymentGroupId)
    def getDeploymentGroupName: ZIO[Any, AwsError, DeploymentGroupName] =
      AwsError.unwrapOptionField("deploymentGroupName", deploymentGroupName)
    def getDeploymentConfigName: ZIO[Any, AwsError, DeploymentConfigName] =
      AwsError.unwrapOptionField("deploymentConfigName", deploymentConfigName)
    def getEc2TagFilters: ZIO[Any, AwsError, List[
      zio.aws.codedeploy.model.EC2TagFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("ec2TagFilters", ec2TagFilters)
    def getOnPremisesInstanceTagFilters: ZIO[Any, AwsError, List[
      zio.aws.codedeploy.model.TagFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "onPremisesInstanceTagFilters",
      onPremisesInstanceTagFilters
    )
    def getAutoScalingGroups: ZIO[Any, AwsError, List[
      zio.aws.codedeploy.model.AutoScalingGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("autoScalingGroups", autoScalingGroups)
    def getServiceRoleArn: ZIO[Any, AwsError, Role] =
      AwsError.unwrapOptionField("serviceRoleArn", serviceRoleArn)
    def getTargetRevision: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.RevisionLocation.ReadOnly
    ] = AwsError.unwrapOptionField("targetRevision", targetRevision)
    def getTriggerConfigurations: ZIO[Any, AwsError, List[
      zio.aws.codedeploy.model.TriggerConfig.ReadOnly
    ]] =
      AwsError.unwrapOptionField("triggerConfigurations", triggerConfigurations)
    def getAlarmConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.AlarmConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("alarmConfiguration", alarmConfiguration)
    def getAutoRollbackConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.AutoRollbackConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "autoRollbackConfiguration",
      autoRollbackConfiguration
    )
    def getDeploymentStyle: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.DeploymentStyle.ReadOnly
    ] = AwsError.unwrapOptionField("deploymentStyle", deploymentStyle)
    def getOutdatedInstancesStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.OutdatedInstancesStrategy
    ] = AwsError.unwrapOptionField(
      "outdatedInstancesStrategy",
      outdatedInstancesStrategy
    )
    def getBlueGreenDeploymentConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.BlueGreenDeploymentConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "blueGreenDeploymentConfiguration",
      blueGreenDeploymentConfiguration
    )
    def getLoadBalancerInfo: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.LoadBalancerInfo.ReadOnly
    ] = AwsError.unwrapOptionField("loadBalancerInfo", loadBalancerInfo)
    def getLastSuccessfulDeployment: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.LastDeploymentInfo.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lastSuccessfulDeployment",
      lastSuccessfulDeployment
    )
    def getLastAttemptedDeployment: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.LastDeploymentInfo.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lastAttemptedDeployment",
      lastAttemptedDeployment
    )
    def getEc2TagSet
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.EC2TagSet.ReadOnly] =
      AwsError.unwrapOptionField("ec2TagSet", ec2TagSet)
    def getOnPremisesTagSet: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.OnPremisesTagSet.ReadOnly
    ] = AwsError.unwrapOptionField("onPremisesTagSet", onPremisesTagSet)
    def getComputePlatform
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.ComputePlatform] =
      AwsError.unwrapOptionField("computePlatform", computePlatform)
    def getEcsServices: ZIO[Any, AwsError, List[
      zio.aws.codedeploy.model.ECSService.ReadOnly
    ]] = AwsError.unwrapOptionField("ecsServices", ecsServices)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.DeploymentGroupInfo
  ) extends zio.aws.codedeploy.model.DeploymentGroupInfo.ReadOnly {
    override val applicationName: Option[ApplicationName] = scala
      .Option(impl.applicationName())
      .map(value => zio.aws.codedeploy.model.primitives.ApplicationName(value))
    override val deploymentGroupId: Option[DeploymentGroupId] = scala
      .Option(impl.deploymentGroupId())
      .map(value =>
        zio.aws.codedeploy.model.primitives.DeploymentGroupId(value)
      )
    override val deploymentGroupName: Option[DeploymentGroupName] = scala
      .Option(impl.deploymentGroupName())
      .map(value =>
        zio.aws.codedeploy.model.primitives.DeploymentGroupName(value)
      )
    override val deploymentConfigName: Option[DeploymentConfigName] = scala
      .Option(impl.deploymentConfigName())
      .map(value =>
        zio.aws.codedeploy.model.primitives.DeploymentConfigName(value)
      )
    override val ec2TagFilters
        : Option[List[zio.aws.codedeploy.model.EC2TagFilter.ReadOnly]] = scala
      .Option(impl.ec2TagFilters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codedeploy.model.EC2TagFilter.wrap(item)
        }.toList
      )
    override val onPremisesInstanceTagFilters
        : Option[List[zio.aws.codedeploy.model.TagFilter.ReadOnly]] = scala
      .Option(impl.onPremisesInstanceTagFilters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codedeploy.model.TagFilter.wrap(item)
        }.toList
      )
    override val autoScalingGroups
        : Option[List[zio.aws.codedeploy.model.AutoScalingGroup.ReadOnly]] =
      scala
        .Option(impl.autoScalingGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.AutoScalingGroup.wrap(item)
          }.toList
        )
    override val serviceRoleArn: Option[Role] = scala
      .Option(impl.serviceRoleArn())
      .map(value => zio.aws.codedeploy.model.primitives.Role(value))
    override val targetRevision
        : Option[zio.aws.codedeploy.model.RevisionLocation.ReadOnly] = scala
      .Option(impl.targetRevision())
      .map(value => zio.aws.codedeploy.model.RevisionLocation.wrap(value))
    override val triggerConfigurations
        : Option[List[zio.aws.codedeploy.model.TriggerConfig.ReadOnly]] = scala
      .Option(impl.triggerConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codedeploy.model.TriggerConfig.wrap(item)
        }.toList
      )
    override val alarmConfiguration
        : Option[zio.aws.codedeploy.model.AlarmConfiguration.ReadOnly] = scala
      .Option(impl.alarmConfiguration())
      .map(value => zio.aws.codedeploy.model.AlarmConfiguration.wrap(value))
    override val autoRollbackConfiguration
        : Option[zio.aws.codedeploy.model.AutoRollbackConfiguration.ReadOnly] =
      scala
        .Option(impl.autoRollbackConfiguration())
        .map(value =>
          zio.aws.codedeploy.model.AutoRollbackConfiguration.wrap(value)
        )
    override val deploymentStyle
        : Option[zio.aws.codedeploy.model.DeploymentStyle.ReadOnly] = scala
      .Option(impl.deploymentStyle())
      .map(value => zio.aws.codedeploy.model.DeploymentStyle.wrap(value))
    override val outdatedInstancesStrategy
        : Option[zio.aws.codedeploy.model.OutdatedInstancesStrategy] = scala
      .Option(impl.outdatedInstancesStrategy())
      .map(value =>
        zio.aws.codedeploy.model.OutdatedInstancesStrategy.wrap(value)
      )
    override val blueGreenDeploymentConfiguration: Option[
      zio.aws.codedeploy.model.BlueGreenDeploymentConfiguration.ReadOnly
    ] = scala
      .Option(impl.blueGreenDeploymentConfiguration())
      .map(value =>
        zio.aws.codedeploy.model.BlueGreenDeploymentConfiguration.wrap(value)
      )
    override val loadBalancerInfo
        : Option[zio.aws.codedeploy.model.LoadBalancerInfo.ReadOnly] = scala
      .Option(impl.loadBalancerInfo())
      .map(value => zio.aws.codedeploy.model.LoadBalancerInfo.wrap(value))
    override val lastSuccessfulDeployment
        : Option[zio.aws.codedeploy.model.LastDeploymentInfo.ReadOnly] = scala
      .Option(impl.lastSuccessfulDeployment())
      .map(value => zio.aws.codedeploy.model.LastDeploymentInfo.wrap(value))
    override val lastAttemptedDeployment
        : Option[zio.aws.codedeploy.model.LastDeploymentInfo.ReadOnly] = scala
      .Option(impl.lastAttemptedDeployment())
      .map(value => zio.aws.codedeploy.model.LastDeploymentInfo.wrap(value))
    override val ec2TagSet
        : Option[zio.aws.codedeploy.model.EC2TagSet.ReadOnly] = scala
      .Option(impl.ec2TagSet())
      .map(value => zio.aws.codedeploy.model.EC2TagSet.wrap(value))
    override val onPremisesTagSet
        : Option[zio.aws.codedeploy.model.OnPremisesTagSet.ReadOnly] = scala
      .Option(impl.onPremisesTagSet())
      .map(value => zio.aws.codedeploy.model.OnPremisesTagSet.wrap(value))
    override val computePlatform
        : Option[zio.aws.codedeploy.model.ComputePlatform] = scala
      .Option(impl.computePlatform())
      .map(value => zio.aws.codedeploy.model.ComputePlatform.wrap(value))
    override val ecsServices
        : Option[List[zio.aws.codedeploy.model.ECSService.ReadOnly]] = scala
      .Option(impl.ecsServices())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codedeploy.model.ECSService.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.DeploymentGroupInfo
  ): zio.aws.codedeploy.model.DeploymentGroupInfo.ReadOnly = new Wrapper(impl)
}
