package zio.aws.codedeploy.model
import scala.jdk.CollectionConverters.*
sealed trait DeploymentOption {
  def unwrap: software.amazon.awssdk.services.codedeploy.model.DeploymentOption
}
object DeploymentOption {
  def wrap(
      value: software.amazon.awssdk.services.codedeploy.model.DeploymentOption
  ): zio.aws.codedeploy.model.DeploymentOption = value match {
    case software.amazon.awssdk.services.codedeploy.model.DeploymentOption.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codedeploy.model.DeploymentOption.WITH_TRAFFIC_CONTROL =>
      val r = WITH_TRAFFIC_CONTROL
      r
    case software.amazon.awssdk.services.codedeploy.model.DeploymentOption.WITHOUT_TRAFFIC_CONTROL =>
      val r = WITHOUT_TRAFFIC_CONTROL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codedeploy.model.DeploymentOption {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.DeploymentOption =
      software.amazon.awssdk.services.codedeploy.model.DeploymentOption.UNKNOWN_TO_SDK_VERSION
  }
  case object WITH_TRAFFIC_CONTROL
      extends zio.aws.codedeploy.model.DeploymentOption {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.DeploymentOption =
      software.amazon.awssdk.services.codedeploy.model.DeploymentOption.WITH_TRAFFIC_CONTROL
  }
  case object WITHOUT_TRAFFIC_CONTROL
      extends zio.aws.codedeploy.model.DeploymentOption {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.DeploymentOption =
      software.amazon.awssdk.services.codedeploy.model.DeploymentOption.WITHOUT_TRAFFIC_CONTROL
  }
}
