package zio.aws.codedeploy.model
import scala.jdk.CollectionConverters.*
sealed trait DeploymentTargetType {
  def unwrap
      : software.amazon.awssdk.services.codedeploy.model.DeploymentTargetType
}
object DeploymentTargetType {
  def wrap(
      value: software.amazon.awssdk.services.codedeploy.model.DeploymentTargetType
  ): zio.aws.codedeploy.model.DeploymentTargetType = value match {
    case software.amazon.awssdk.services.codedeploy.model.DeploymentTargetType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codedeploy.model.DeploymentTargetType.INSTANCE_TARGET =>
      val r = InstanceTarget
      r
    case software.amazon.awssdk.services.codedeploy.model.DeploymentTargetType.LAMBDA_TARGET =>
      val r = LambdaTarget
      r
    case software.amazon.awssdk.services.codedeploy.model.DeploymentTargetType.ECS_TARGET =>
      val r = ECSTarget
      r
    case software.amazon.awssdk.services.codedeploy.model.DeploymentTargetType.CLOUD_FORMATION_TARGET =>
      val r = CloudFormationTarget
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codedeploy.model.DeploymentTargetType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.DeploymentTargetType =
      software.amazon.awssdk.services.codedeploy.model.DeploymentTargetType.UNKNOWN_TO_SDK_VERSION
  }
  case object InstanceTarget
      extends zio.aws.codedeploy.model.DeploymentTargetType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.DeploymentTargetType =
      software.amazon.awssdk.services.codedeploy.model.DeploymentTargetType.INSTANCE_TARGET
  }
  case object LambdaTarget
      extends zio.aws.codedeploy.model.DeploymentTargetType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.DeploymentTargetType =
      software.amazon.awssdk.services.codedeploy.model.DeploymentTargetType.LAMBDA_TARGET
  }
  case object ECSTarget extends zio.aws.codedeploy.model.DeploymentTargetType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.DeploymentTargetType =
      software.amazon.awssdk.services.codedeploy.model.DeploymentTargetType.ECS_TARGET
  }
  case object CloudFormationTarget
      extends zio.aws.codedeploy.model.DeploymentTargetType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.DeploymentTargetType =
      software.amazon.awssdk.services.codedeploy.model.DeploymentTargetType.CLOUD_FORMATION_TARGET
  }
}
