package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codedeploy.model.primitives.InstanceName
import scala.jdk.CollectionConverters.*
final case class DeregisterOnPremisesInstanceRequest(
    instanceName: InstanceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.DeregisterOnPremisesInstanceRequest = {
    import DeregisterOnPremisesInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.DeregisterOnPremisesInstanceRequest
      .builder()
      .instanceName(InstanceName.unwrap(instanceName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.DeregisterOnPremisesInstanceRequest.ReadOnly =
    zio.aws.codedeploy.model.DeregisterOnPremisesInstanceRequest
      .wrap(buildAwsValue())
}
object DeregisterOnPremisesInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.DeregisterOnPremisesInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codedeploy.model.DeregisterOnPremisesInstanceRequest =
      zio.aws.codedeploy.model.DeregisterOnPremisesInstanceRequest(instanceName)
    def instanceName: InstanceName
    def getInstanceName: ZIO[Any, Nothing, InstanceName] =
      ZIO.succeed(instanceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.DeregisterOnPremisesInstanceRequest
  ) extends zio.aws.codedeploy.model.DeregisterOnPremisesInstanceRequest.ReadOnly {
    override val instanceName: InstanceName =
      zio.aws.codedeploy.model.primitives.InstanceName(impl.instanceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.DeregisterOnPremisesInstanceRequest
  ): zio.aws.codedeploy.model.DeregisterOnPremisesInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
