package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{ECSClusterName, ECSServiceName}
import scala.jdk.CollectionConverters.*
final case class ECSService(
    serviceName: Option[ECSServiceName] = None,
    clusterName: Option[ECSClusterName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.ECSService = {
    import ECSService.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.ECSService
      .builder()
      .optionallyWith(
        serviceName.map(value => ECSServiceName.unwrap(value): java.lang.String)
      )(_.serviceName)
      .optionallyWith(
        clusterName.map(value => ECSClusterName.unwrap(value): java.lang.String)
      )(_.clusterName)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.ECSService.ReadOnly =
    zio.aws.codedeploy.model.ECSService.wrap(buildAwsValue())
}
object ECSService {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.ECSService
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.ECSService =
      zio.aws.codedeploy.model.ECSService(
        serviceName.map(value => value),
        clusterName.map(value => value)
      )
    def serviceName: Option[ECSServiceName]
    def clusterName: Option[ECSClusterName]
    def getServiceName: ZIO[Any, AwsError, ECSServiceName] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getClusterName: ZIO[Any, AwsError, ECSClusterName] =
      AwsError.unwrapOptionField("clusterName", clusterName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.ECSService
  ) extends zio.aws.codedeploy.model.ECSService.ReadOnly {
    override val serviceName: Option[ECSServiceName] = scala
      .Option(impl.serviceName())
      .map(value => zio.aws.codedeploy.model.primitives.ECSServiceName(value))
    override val clusterName: Option[ECSClusterName] = scala
      .Option(impl.clusterName())
      .map(value => zio.aws.codedeploy.model.primitives.ECSClusterName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.ECSService
  ): zio.aws.codedeploy.model.ECSService.ReadOnly = new Wrapper(impl)
}
