package zio.aws.codedeploy.model
import scala.jdk.CollectionConverters.*
sealed trait ErrorCode {
  def unwrap: software.amazon.awssdk.services.codedeploy.model.ErrorCode
}
object ErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.codedeploy.model.ErrorCode
  ): zio.aws.codedeploy.model.ErrorCode = value match {
    case software.amazon.awssdk.services.codedeploy.model.ErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codedeploy.model.ErrorCode.AGENT_ISSUE =>
      val r = AGENT_ISSUE
      r
    case software.amazon.awssdk.services.codedeploy.model.ErrorCode.ALARM_ACTIVE =>
      val r = ALARM_ACTIVE
      r
    case software.amazon.awssdk.services.codedeploy.model.ErrorCode.APPLICATION_MISSING =>
      val r = APPLICATION_MISSING
      r
    case software.amazon.awssdk.services.codedeploy.model.ErrorCode.AUTOSCALING_VALIDATION_ERROR =>
      val r = AUTOSCALING_VALIDATION_ERROR
      r
    case software.amazon.awssdk.services.codedeploy.model.ErrorCode.AUTO_SCALING_CONFIGURATION =>
      val r = AUTO_SCALING_CONFIGURATION
      r
    case software.amazon.awssdk.services.codedeploy.model.ErrorCode.AUTO_SCALING_IAM_ROLE_PERMISSIONS =>
      val r = AUTO_SCALING_IAM_ROLE_PERMISSIONS
      r
    case software.amazon.awssdk.services.codedeploy.model.ErrorCode.CODEDEPLOY_RESOURCE_CANNOT_BE_FOUND =>
      val r = CODEDEPLOY_RESOURCE_CANNOT_BE_FOUND
      r
    case software.amazon.awssdk.services.codedeploy.model.ErrorCode.CUSTOMER_APPLICATION_UNHEALTHY =>
      val r = CUSTOMER_APPLICATION_UNHEALTHY
      r
    case software.amazon.awssdk.services.codedeploy.model.ErrorCode.DEPLOYMENT_GROUP_MISSING =>
      val r = DEPLOYMENT_GROUP_MISSING
      r
    case software.amazon.awssdk.services.codedeploy.model.ErrorCode.ECS_UPDATE_ERROR =>
      val r = ECS_UPDATE_ERROR
      r
    case software.amazon.awssdk.services.codedeploy.model.ErrorCode.ELASTIC_LOAD_BALANCING_INVALID =>
      val r = ELASTIC_LOAD_BALANCING_INVALID
      r
    case software.amazon.awssdk.services.codedeploy.model.ErrorCode.ELB_INVALID_INSTANCE =>
      val r = ELB_INVALID_INSTANCE
      r
    case software.amazon.awssdk.services.codedeploy.model.ErrorCode.HEALTH_CONSTRAINTS =>
      val r = HEALTH_CONSTRAINTS
      r
    case software.amazon.awssdk.services.codedeploy.model.ErrorCode.HEALTH_CONSTRAINTS_INVALID =>
      val r = HEALTH_CONSTRAINTS_INVALID
      r
    case software.amazon.awssdk.services.codedeploy.model.ErrorCode.HOOK_EXECUTION_FAILURE =>
      val r = HOOK_EXECUTION_FAILURE
      r
    case software.amazon.awssdk.services.codedeploy.model.ErrorCode.IAM_ROLE_MISSING =>
      val r = IAM_ROLE_MISSING
      r
    case software.amazon.awssdk.services.codedeploy.model.ErrorCode.IAM_ROLE_PERMISSIONS =>
      val r = IAM_ROLE_PERMISSIONS
      r
    case software.amazon.awssdk.services.codedeploy.model.ErrorCode.INTERNAL_ERROR =>
      val r = INTERNAL_ERROR
      r
    case software.amazon.awssdk.services.codedeploy.model.ErrorCode.INVALID_ECS_SERVICE =>
      val r = INVALID_ECS_SERVICE
      r
    case software.amazon.awssdk.services.codedeploy.model.ErrorCode.INVALID_LAMBDA_CONFIGURATION =>
      val r = INVALID_LAMBDA_CONFIGURATION
      r
    case software.amazon.awssdk.services.codedeploy.model.ErrorCode.INVALID_LAMBDA_FUNCTION =>
      val r = INVALID_LAMBDA_FUNCTION
      r
    case software.amazon.awssdk.services.codedeploy.model.ErrorCode.INVALID_REVISION =>
      val r = INVALID_REVISION
      r
    case software.amazon.awssdk.services.codedeploy.model.ErrorCode.MANUAL_STOP =>
      val r = MANUAL_STOP
      r
    case software.amazon.awssdk.services.codedeploy.model.ErrorCode.MISSING_BLUE_GREEN_DEPLOYMENT_CONFIGURATION =>
      val r = MISSING_BLUE_GREEN_DEPLOYMENT_CONFIGURATION
      r
    case software.amazon.awssdk.services.codedeploy.model.ErrorCode.MISSING_ELB_INFORMATION =>
      val r = MISSING_ELB_INFORMATION
      r
    case software.amazon.awssdk.services.codedeploy.model.ErrorCode.MISSING_GITHUB_TOKEN =>
      val r = MISSING_GITHUB_TOKEN
      r
    case software.amazon.awssdk.services.codedeploy.model.ErrorCode.NO_EC2_SUBSCRIPTION =>
      val r = NO_EC2_SUBSCRIPTION
      r
    case software.amazon.awssdk.services.codedeploy.model.ErrorCode.NO_INSTANCES =>
      val r = NO_INSTANCES
      r
    case software.amazon.awssdk.services.codedeploy.model.ErrorCode.OVER_MAX_INSTANCES =>
      val r = OVER_MAX_INSTANCES
      r
    case software.amazon.awssdk.services.codedeploy.model.ErrorCode.RESOURCE_LIMIT_EXCEEDED =>
      val r = RESOURCE_LIMIT_EXCEEDED
      r
    case software.amazon.awssdk.services.codedeploy.model.ErrorCode.REVISION_MISSING =>
      val r = REVISION_MISSING
      r
    case software.amazon.awssdk.services.codedeploy.model.ErrorCode.THROTTLED =>
      val r = THROTTLED
      r
    case software.amazon.awssdk.services.codedeploy.model.ErrorCode.TIMEOUT =>
      val r = TIMEOUT
      r
    case software.amazon.awssdk.services.codedeploy.model.ErrorCode.CLOUDFORMATION_STACK_FAILURE =>
      val r = CLOUDFORMATION_STACK_FAILURE
      r
  }
  case object unknownToSdkVersion extends zio.aws.codedeploy.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ErrorCode =
      software.amazon.awssdk.services.codedeploy.model.ErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object AGENT_ISSUE extends zio.aws.codedeploy.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ErrorCode =
      software.amazon.awssdk.services.codedeploy.model.ErrorCode.AGENT_ISSUE
  }
  case object ALARM_ACTIVE extends zio.aws.codedeploy.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ErrorCode =
      software.amazon.awssdk.services.codedeploy.model.ErrorCode.ALARM_ACTIVE
  }
  case object APPLICATION_MISSING extends zio.aws.codedeploy.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ErrorCode =
      software.amazon.awssdk.services.codedeploy.model.ErrorCode.APPLICATION_MISSING
  }
  case object AUTOSCALING_VALIDATION_ERROR
      extends zio.aws.codedeploy.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ErrorCode =
      software.amazon.awssdk.services.codedeploy.model.ErrorCode.AUTOSCALING_VALIDATION_ERROR
  }
  case object AUTO_SCALING_CONFIGURATION
      extends zio.aws.codedeploy.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ErrorCode =
      software.amazon.awssdk.services.codedeploy.model.ErrorCode.AUTO_SCALING_CONFIGURATION
  }
  case object AUTO_SCALING_IAM_ROLE_PERMISSIONS
      extends zio.aws.codedeploy.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ErrorCode =
      software.amazon.awssdk.services.codedeploy.model.ErrorCode.AUTO_SCALING_IAM_ROLE_PERMISSIONS
  }
  case object CODEDEPLOY_RESOURCE_CANNOT_BE_FOUND
      extends zio.aws.codedeploy.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ErrorCode =
      software.amazon.awssdk.services.codedeploy.model.ErrorCode.CODEDEPLOY_RESOURCE_CANNOT_BE_FOUND
  }
  case object CUSTOMER_APPLICATION_UNHEALTHY
      extends zio.aws.codedeploy.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ErrorCode =
      software.amazon.awssdk.services.codedeploy.model.ErrorCode.CUSTOMER_APPLICATION_UNHEALTHY
  }
  case object DEPLOYMENT_GROUP_MISSING
      extends zio.aws.codedeploy.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ErrorCode =
      software.amazon.awssdk.services.codedeploy.model.ErrorCode.DEPLOYMENT_GROUP_MISSING
  }
  case object ECS_UPDATE_ERROR extends zio.aws.codedeploy.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ErrorCode =
      software.amazon.awssdk.services.codedeploy.model.ErrorCode.ECS_UPDATE_ERROR
  }
  case object ELASTIC_LOAD_BALANCING_INVALID
      extends zio.aws.codedeploy.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ErrorCode =
      software.amazon.awssdk.services.codedeploy.model.ErrorCode.ELASTIC_LOAD_BALANCING_INVALID
  }
  case object ELB_INVALID_INSTANCE extends zio.aws.codedeploy.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ErrorCode =
      software.amazon.awssdk.services.codedeploy.model.ErrorCode.ELB_INVALID_INSTANCE
  }
  case object HEALTH_CONSTRAINTS extends zio.aws.codedeploy.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ErrorCode =
      software.amazon.awssdk.services.codedeploy.model.ErrorCode.HEALTH_CONSTRAINTS
  }
  case object HEALTH_CONSTRAINTS_INVALID
      extends zio.aws.codedeploy.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ErrorCode =
      software.amazon.awssdk.services.codedeploy.model.ErrorCode.HEALTH_CONSTRAINTS_INVALID
  }
  case object HOOK_EXECUTION_FAILURE
      extends zio.aws.codedeploy.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ErrorCode =
      software.amazon.awssdk.services.codedeploy.model.ErrorCode.HOOK_EXECUTION_FAILURE
  }
  case object IAM_ROLE_MISSING extends zio.aws.codedeploy.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ErrorCode =
      software.amazon.awssdk.services.codedeploy.model.ErrorCode.IAM_ROLE_MISSING
  }
  case object IAM_ROLE_PERMISSIONS extends zio.aws.codedeploy.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ErrorCode =
      software.amazon.awssdk.services.codedeploy.model.ErrorCode.IAM_ROLE_PERMISSIONS
  }
  case object INTERNAL_ERROR extends zio.aws.codedeploy.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ErrorCode =
      software.amazon.awssdk.services.codedeploy.model.ErrorCode.INTERNAL_ERROR
  }
  case object INVALID_ECS_SERVICE extends zio.aws.codedeploy.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ErrorCode =
      software.amazon.awssdk.services.codedeploy.model.ErrorCode.INVALID_ECS_SERVICE
  }
  case object INVALID_LAMBDA_CONFIGURATION
      extends zio.aws.codedeploy.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ErrorCode =
      software.amazon.awssdk.services.codedeploy.model.ErrorCode.INVALID_LAMBDA_CONFIGURATION
  }
  case object INVALID_LAMBDA_FUNCTION
      extends zio.aws.codedeploy.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ErrorCode =
      software.amazon.awssdk.services.codedeploy.model.ErrorCode.INVALID_LAMBDA_FUNCTION
  }
  case object INVALID_REVISION extends zio.aws.codedeploy.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ErrorCode =
      software.amazon.awssdk.services.codedeploy.model.ErrorCode.INVALID_REVISION
  }
  case object MANUAL_STOP extends zio.aws.codedeploy.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ErrorCode =
      software.amazon.awssdk.services.codedeploy.model.ErrorCode.MANUAL_STOP
  }
  case object MISSING_BLUE_GREEN_DEPLOYMENT_CONFIGURATION
      extends zio.aws.codedeploy.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ErrorCode =
      software.amazon.awssdk.services.codedeploy.model.ErrorCode.MISSING_BLUE_GREEN_DEPLOYMENT_CONFIGURATION
  }
  case object MISSING_ELB_INFORMATION
      extends zio.aws.codedeploy.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ErrorCode =
      software.amazon.awssdk.services.codedeploy.model.ErrorCode.MISSING_ELB_INFORMATION
  }
  case object MISSING_GITHUB_TOKEN extends zio.aws.codedeploy.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ErrorCode =
      software.amazon.awssdk.services.codedeploy.model.ErrorCode.MISSING_GITHUB_TOKEN
  }
  case object NO_EC2_SUBSCRIPTION extends zio.aws.codedeploy.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ErrorCode =
      software.amazon.awssdk.services.codedeploy.model.ErrorCode.NO_EC2_SUBSCRIPTION
  }
  case object NO_INSTANCES extends zio.aws.codedeploy.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ErrorCode =
      software.amazon.awssdk.services.codedeploy.model.ErrorCode.NO_INSTANCES
  }
  case object OVER_MAX_INSTANCES extends zio.aws.codedeploy.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ErrorCode =
      software.amazon.awssdk.services.codedeploy.model.ErrorCode.OVER_MAX_INSTANCES
  }
  case object RESOURCE_LIMIT_EXCEEDED
      extends zio.aws.codedeploy.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ErrorCode =
      software.amazon.awssdk.services.codedeploy.model.ErrorCode.RESOURCE_LIMIT_EXCEEDED
  }
  case object REVISION_MISSING extends zio.aws.codedeploy.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ErrorCode =
      software.amazon.awssdk.services.codedeploy.model.ErrorCode.REVISION_MISSING
  }
  case object THROTTLED extends zio.aws.codedeploy.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ErrorCode =
      software.amazon.awssdk.services.codedeploy.model.ErrorCode.THROTTLED
  }
  case object TIMEOUT extends zio.aws.codedeploy.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ErrorCode =
      software.amazon.awssdk.services.codedeploy.model.ErrorCode.TIMEOUT
  }
  case object CLOUDFORMATION_STACK_FAILURE
      extends zio.aws.codedeploy.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ErrorCode =
      software.amazon.awssdk.services.codedeploy.model.ErrorCode.CLOUDFORMATION_STACK_FAILURE
  }
}
