package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDeploymentConfigResponse(
    deploymentConfigInfo: Option[
      zio.aws.codedeploy.model.DeploymentConfigInfo
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.GetDeploymentConfigResponse = {
    import GetDeploymentConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.GetDeploymentConfigResponse
      .builder()
      .optionallyWith(deploymentConfigInfo.map(value => value.buildAwsValue()))(
        _.deploymentConfigInfo
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.GetDeploymentConfigResponse.ReadOnly =
    zio.aws.codedeploy.model.GetDeploymentConfigResponse.wrap(buildAwsValue())
}
object GetDeploymentConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.GetDeploymentConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.GetDeploymentConfigResponse =
      zio.aws.codedeploy.model.GetDeploymentConfigResponse(
        deploymentConfigInfo.map(value => value.asEditable)
      )
    def deploymentConfigInfo
        : Option[zio.aws.codedeploy.model.DeploymentConfigInfo.ReadOnly]
    def getDeploymentConfigInfo: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.DeploymentConfigInfo.ReadOnly
    ] = AwsError.unwrapOptionField("deploymentConfigInfo", deploymentConfigInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.GetDeploymentConfigResponse
  ) extends zio.aws.codedeploy.model.GetDeploymentConfigResponse.ReadOnly {
    override val deploymentConfigInfo
        : Option[zio.aws.codedeploy.model.DeploymentConfigInfo.ReadOnly] = scala
      .Option(impl.deploymentConfigInfo())
      .map(value => zio.aws.codedeploy.model.DeploymentConfigInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.GetDeploymentConfigResponse
  ): zio.aws.codedeploy.model.GetDeploymentConfigResponse.ReadOnly =
    new Wrapper(impl)
}
