package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{TargetId, DeploymentId}
import scala.jdk.CollectionConverters.*
final case class GetDeploymentTargetRequest(
    deploymentId: Option[DeploymentId] = None,
    targetId: Option[TargetId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.GetDeploymentTargetRequest = {
    import GetDeploymentTargetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.GetDeploymentTargetRequest
      .builder()
      .optionallyWith(
        deploymentId.map(value => DeploymentId.unwrap(value): java.lang.String)
      )(_.deploymentId)
      .optionallyWith(
        targetId.map(value => TargetId.unwrap(value): java.lang.String)
      )(_.targetId)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.GetDeploymentTargetRequest.ReadOnly =
    zio.aws.codedeploy.model.GetDeploymentTargetRequest.wrap(buildAwsValue())
}
object GetDeploymentTargetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.GetDeploymentTargetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.GetDeploymentTargetRequest =
      zio.aws.codedeploy.model.GetDeploymentTargetRequest(
        deploymentId.map(value => value),
        targetId.map(value => value)
      )
    def deploymentId: Option[DeploymentId]
    def targetId: Option[TargetId]
    def getDeploymentId: ZIO[Any, AwsError, DeploymentId] =
      AwsError.unwrapOptionField("deploymentId", deploymentId)
    def getTargetId: ZIO[Any, AwsError, TargetId] =
      AwsError.unwrapOptionField("targetId", targetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.GetDeploymentTargetRequest
  ) extends zio.aws.codedeploy.model.GetDeploymentTargetRequest.ReadOnly {
    override val deploymentId: Option[DeploymentId] = scala
      .Option(impl.deploymentId())
      .map(value => zio.aws.codedeploy.model.primitives.DeploymentId(value))
    override val targetId: Option[TargetId] = scala
      .Option(impl.targetId())
      .map(value => zio.aws.codedeploy.model.primitives.TargetId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.GetDeploymentTargetRequest
  ): zio.aws.codedeploy.model.GetDeploymentTargetRequest.ReadOnly = new Wrapper(
    impl
  )
}
