package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListApplicationRevisionsResponse(
    revisions: Option[Iterable[zio.aws.codedeploy.model.RevisionLocation]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsResponse = {
    import ListApplicationRevisionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsResponse
      .builder()
      .optionallyWith(
        revisions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.revisions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.ListApplicationRevisionsResponse.ReadOnly =
    zio.aws.codedeploy.model.ListApplicationRevisionsResponse
      .wrap(buildAwsValue())
}
object ListApplicationRevisionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.ListApplicationRevisionsResponse =
      zio.aws.codedeploy.model.ListApplicationRevisionsResponse(
        revisions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def revisions
        : Option[List[zio.aws.codedeploy.model.RevisionLocation.ReadOnly]]
    def nextToken: Option[NextToken]
    def getRevisions: ZIO[Any, AwsError, List[
      zio.aws.codedeploy.model.RevisionLocation.ReadOnly
    ]] = AwsError.unwrapOptionField("revisions", revisions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsResponse
  ) extends zio.aws.codedeploy.model.ListApplicationRevisionsResponse.ReadOnly {
    override val revisions
        : Option[List[zio.aws.codedeploy.model.RevisionLocation.ReadOnly]] =
      scala
        .Option(impl.revisions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.RevisionLocation.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codedeploy.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsResponse
  ): zio.aws.codedeploy.model.ListApplicationRevisionsResponse.ReadOnly =
    new Wrapper(impl)
}
