package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListApplicationsRequest(nextToken: Option[NextToken] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.ListApplicationsRequest = {
    import ListApplicationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.ListApplicationsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.ListApplicationsRequest.ReadOnly =
    zio.aws.codedeploy.model.ListApplicationsRequest.wrap(buildAwsValue())
}
object ListApplicationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.ListApplicationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.ListApplicationsRequest =
      zio.aws.codedeploy.model
        .ListApplicationsRequest(nextToken.map(value => value))
    def nextToken: Option[NextToken]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.ListApplicationsRequest
  ) extends zio.aws.codedeploy.model.ListApplicationsRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codedeploy.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.ListApplicationsRequest
  ): zio.aws.codedeploy.model.ListApplicationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
