package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{RawStringSha256, RawStringContent}
import scala.jdk.CollectionConverters.*
final case class RawString(
    content: Option[RawStringContent] = None,
    sha256: Option[RawStringSha256] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.RawString = {
    import RawString.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.RawString
      .builder()
      .optionallyWith(
        content.map(value => RawStringContent.unwrap(value): java.lang.String)
      )(_.content)
      .optionallyWith(
        sha256.map(value => RawStringSha256.unwrap(value): java.lang.String)
      )(_.sha256)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.RawString.ReadOnly =
    zio.aws.codedeploy.model.RawString.wrap(buildAwsValue())
}
object RawString {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.RawString
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.RawString =
      zio.aws.codedeploy.model
        .RawString(content.map(value => value), sha256.map(value => value))
    def content: Option[RawStringContent]
    def sha256: Option[RawStringSha256]
    def getContent: ZIO[Any, AwsError, RawStringContent] =
      AwsError.unwrapOptionField("content", content)
    def getSha256: ZIO[Any, AwsError, RawStringSha256] =
      AwsError.unwrapOptionField("sha256", sha256)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.RawString
  ) extends zio.aws.codedeploy.model.RawString.ReadOnly {
    override val content: Option[RawStringContent] = scala
      .Option(impl.content())
      .map(value => zio.aws.codedeploy.model.primitives.RawStringContent(value))
    override val sha256: Option[RawStringSha256] = scala
      .Option(impl.sha256())
      .map(value => zio.aws.codedeploy.model.primitives.RawStringSha256(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.RawString
  ): zio.aws.codedeploy.model.RawString.ReadOnly = new Wrapper(impl)
}
