package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RevisionLocation(
    revisionType: Option[zio.aws.codedeploy.model.RevisionLocationType] = None,
    s3Location: Option[zio.aws.codedeploy.model.S3Location] = None,
    gitHubLocation: Option[zio.aws.codedeploy.model.GitHubLocation] = None,
    string: Option[zio.aws.codedeploy.model.RawString] = None,
    appSpecContent: Option[zio.aws.codedeploy.model.AppSpecContent] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.RevisionLocation = {
    import RevisionLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.RevisionLocation
      .builder()
      .optionallyWith(revisionType.map(value => value.unwrap))(_.revisionType)
      .optionallyWith(s3Location.map(value => value.buildAwsValue()))(
        _.s3Location
      )
      .optionallyWith(gitHubLocation.map(value => value.buildAwsValue()))(
        _.gitHubLocation
      )
      .optionallyWith(string.map(value => value.buildAwsValue()))(_.string)
      .optionallyWith(appSpecContent.map(value => value.buildAwsValue()))(
        _.appSpecContent
      )
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.RevisionLocation.ReadOnly =
    zio.aws.codedeploy.model.RevisionLocation.wrap(buildAwsValue())
}
object RevisionLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.RevisionLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.RevisionLocation =
      zio.aws.codedeploy.model.RevisionLocation(
        revisionType.map(value => value),
        s3Location.map(value => value.asEditable),
        gitHubLocation.map(value => value.asEditable),
        string.map(value => value.asEditable),
        appSpecContent.map(value => value.asEditable)
      )
    def revisionType: Option[zio.aws.codedeploy.model.RevisionLocationType]
    def s3Location: Option[zio.aws.codedeploy.model.S3Location.ReadOnly]
    def gitHubLocation: Option[zio.aws.codedeploy.model.GitHubLocation.ReadOnly]
    def string: Option[zio.aws.codedeploy.model.RawString.ReadOnly]
    def appSpecContent: Option[zio.aws.codedeploy.model.AppSpecContent.ReadOnly]
    def getRevisionType
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.RevisionLocationType] =
      AwsError.unwrapOptionField("revisionType", revisionType)
    def getS3Location
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.S3Location.ReadOnly] =
      AwsError.unwrapOptionField("s3Location", s3Location)
    def getGitHubLocation
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.GitHubLocation.ReadOnly] =
      AwsError.unwrapOptionField("gitHubLocation", gitHubLocation)
    def getString
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.RawString.ReadOnly] =
      AwsError.unwrapOptionField("string", string)
    def getAppSpecContent
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.AppSpecContent.ReadOnly] =
      AwsError.unwrapOptionField("appSpecContent", appSpecContent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.RevisionLocation
  ) extends zio.aws.codedeploy.model.RevisionLocation.ReadOnly {
    override val revisionType
        : Option[zio.aws.codedeploy.model.RevisionLocationType] = scala
      .Option(impl.revisionType())
      .map(value => zio.aws.codedeploy.model.RevisionLocationType.wrap(value))
    override val s3Location
        : Option[zio.aws.codedeploy.model.S3Location.ReadOnly] = scala
      .Option(impl.s3Location())
      .map(value => zio.aws.codedeploy.model.S3Location.wrap(value))
    override val gitHubLocation
        : Option[zio.aws.codedeploy.model.GitHubLocation.ReadOnly] = scala
      .Option(impl.gitHubLocation())
      .map(value => zio.aws.codedeploy.model.GitHubLocation.wrap(value))
    override val string: Option[zio.aws.codedeploy.model.RawString.ReadOnly] =
      scala
        .Option(impl.string())
        .map(value => zio.aws.codedeploy.model.RawString.wrap(value))
    override val appSpecContent
        : Option[zio.aws.codedeploy.model.AppSpecContent.ReadOnly] = scala
      .Option(impl.appSpecContent())
      .map(value => zio.aws.codedeploy.model.AppSpecContent.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.RevisionLocation
  ): zio.aws.codedeploy.model.RevisionLocation.ReadOnly = new Wrapper(impl)
}
