package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{Description, DeploymentId}
import scala.jdk.CollectionConverters.*
final case class RollbackInfo(
    rollbackDeploymentId: Option[DeploymentId] = None,
    rollbackTriggeringDeploymentId: Option[DeploymentId] = None,
    rollbackMessage: Option[Description] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.RollbackInfo = {
    import RollbackInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.RollbackInfo
      .builder()
      .optionallyWith(
        rollbackDeploymentId.map(value =>
          DeploymentId.unwrap(value): java.lang.String
        )
      )(_.rollbackDeploymentId)
      .optionallyWith(
        rollbackTriggeringDeploymentId.map(value =>
          DeploymentId.unwrap(value): java.lang.String
        )
      )(_.rollbackTriggeringDeploymentId)
      .optionallyWith(
        rollbackMessage.map(value =>
          Description.unwrap(value): java.lang.String
        )
      )(_.rollbackMessage)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.RollbackInfo.ReadOnly =
    zio.aws.codedeploy.model.RollbackInfo.wrap(buildAwsValue())
}
object RollbackInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.RollbackInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.RollbackInfo =
      zio.aws.codedeploy.model.RollbackInfo(
        rollbackDeploymentId.map(value => value),
        rollbackTriggeringDeploymentId.map(value => value),
        rollbackMessage.map(value => value)
      )
    def rollbackDeploymentId: Option[DeploymentId]
    def rollbackTriggeringDeploymentId: Option[DeploymentId]
    def rollbackMessage: Option[Description]
    def getRollbackDeploymentId: ZIO[Any, AwsError, DeploymentId] =
      AwsError.unwrapOptionField("rollbackDeploymentId", rollbackDeploymentId)
    def getRollbackTriggeringDeploymentId: ZIO[Any, AwsError, DeploymentId] =
      AwsError.unwrapOptionField(
        "rollbackTriggeringDeploymentId",
        rollbackTriggeringDeploymentId
      )
    def getRollbackMessage: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("rollbackMessage", rollbackMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.RollbackInfo
  ) extends zio.aws.codedeploy.model.RollbackInfo.ReadOnly {
    override val rollbackDeploymentId: Option[DeploymentId] = scala
      .Option(impl.rollbackDeploymentId())
      .map(value => zio.aws.codedeploy.model.primitives.DeploymentId(value))
    override val rollbackTriggeringDeploymentId: Option[DeploymentId] = scala
      .Option(impl.rollbackTriggeringDeploymentId())
      .map(value => zio.aws.codedeploy.model.primitives.DeploymentId(value))
    override val rollbackMessage: Option[Description] = scala
      .Option(impl.rollbackMessage())
      .map(value => zio.aws.codedeploy.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.RollbackInfo
  ): zio.aws.codedeploy.model.RollbackInfo.ReadOnly = new Wrapper(impl)
}
