package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{Nonce, JobId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AcknowledgeJobRequest(jobId: JobId, nonce: Nonce) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.AcknowledgeJobRequest = {
    import AcknowledgeJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.AcknowledgeJobRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .nonce(Nonce.unwrap(nonce): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.AcknowledgeJobRequest.ReadOnly =
    zio.aws.codepipeline.model.AcknowledgeJobRequest.wrap(buildAwsValue())
}
object AcknowledgeJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.AcknowledgeJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.AcknowledgeJobRequest =
      zio.aws.codepipeline.model.AcknowledgeJobRequest(jobId, nonce)
    def jobId: JobId
    def nonce: Nonce
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getNonce: ZIO[Any, Nothing, Nonce] = ZIO.succeed(nonce)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.AcknowledgeJobRequest
  ) extends zio.aws.codepipeline.model.AcknowledgeJobRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.codepipeline.model.primitives.JobId(impl.jobId())
    override val nonce: Nonce =
      zio.aws.codepipeline.model.primitives.Nonce(impl.nonce())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.AcknowledgeJobRequest
  ): zio.aws.codepipeline.model.AcknowledgeJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
