package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AcknowledgeThirdPartyJobResponse(
    status: Option[zio.aws.codepipeline.model.JobStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.AcknowledgeThirdPartyJobResponse = {
    import AcknowledgeThirdPartyJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.AcknowledgeThirdPartyJobResponse
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.AcknowledgeThirdPartyJobResponse.ReadOnly =
    zio.aws.codepipeline.model.AcknowledgeThirdPartyJobResponse
      .wrap(buildAwsValue())
}
object AcknowledgeThirdPartyJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.AcknowledgeThirdPartyJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codepipeline.model.AcknowledgeThirdPartyJobResponse =
      zio.aws.codepipeline.model
        .AcknowledgeThirdPartyJobResponse(status.map(value => value))
    def status: Option[zio.aws.codepipeline.model.JobStatus]
    def getStatus: ZIO[Any, AwsError, zio.aws.codepipeline.model.JobStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.AcknowledgeThirdPartyJobResponse
  ) extends zio.aws.codepipeline.model.AcknowledgeThirdPartyJobResponse.ReadOnly {
    override val status: Option[zio.aws.codepipeline.model.JobStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.codepipeline.model.JobStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.AcknowledgeThirdPartyJobResponse
  ): zio.aws.codepipeline.model.AcknowledgeThirdPartyJobResponse.ReadOnly =
    new Wrapper(impl)
}
