package zio.aws.codepipeline.model
import scala.jdk.CollectionConverters.*
sealed trait ActionConfigurationPropertyType {
  def unwrap: software.amazon.awssdk.services.codepipeline.model.ActionConfigurationPropertyType
}
object ActionConfigurationPropertyType {
  def wrap(
      value: software.amazon.awssdk.services.codepipeline.model.ActionConfigurationPropertyType
  ): zio.aws.codepipeline.model.ActionConfigurationPropertyType = value match {
    case software.amazon.awssdk.services.codepipeline.model.ActionConfigurationPropertyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codepipeline.model.ActionConfigurationPropertyType.STRING =>
      val r = String
      r
    case software.amazon.awssdk.services.codepipeline.model.ActionConfigurationPropertyType.NUMBER =>
      val r = Number
      r
    case software.amazon.awssdk.services.codepipeline.model.ActionConfigurationPropertyType.BOOLEAN =>
      val r = Boolean
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codepipeline.model.ActionConfigurationPropertyType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ActionConfigurationPropertyType =
      software.amazon.awssdk.services.codepipeline.model.ActionConfigurationPropertyType.UNKNOWN_TO_SDK_VERSION
  }
  case object String
      extends zio.aws.codepipeline.model.ActionConfigurationPropertyType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ActionConfigurationPropertyType =
      software.amazon.awssdk.services.codepipeline.model.ActionConfigurationPropertyType.STRING
  }
  case object Number
      extends zio.aws.codepipeline.model.ActionConfigurationPropertyType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ActionConfigurationPropertyType =
      software.amazon.awssdk.services.codepipeline.model.ActionConfigurationPropertyType.NUMBER
  }
  case object Boolean
      extends zio.aws.codepipeline.model.ActionConfigurationPropertyType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ActionConfigurationPropertyType =
      software.amazon.awssdk.services.codepipeline.model.ActionConfigurationPropertyType.BOOLEAN
  }
}
