package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  ActionConfigurationKey,
  ActionRunOrder,
  ActionNamespace,
  RoleArn,
  ActionName,
  ActionConfigurationValue,
  AWSRegionName
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ActionDeclaration(
    name: ActionName,
    actionTypeId: zio.aws.codepipeline.model.ActionTypeId,
    runOrder: Option[ActionRunOrder] = None,
    configuration: Option[
      Map[ActionConfigurationKey, ActionConfigurationValue]
    ] = None,
    outputArtifacts: Option[
      Iterable[zio.aws.codepipeline.model.OutputArtifact]
    ] = None,
    inputArtifacts: Option[Iterable[zio.aws.codepipeline.model.InputArtifact]] =
      None,
    roleArn: Option[RoleArn] = None,
    region: Option[AWSRegionName] = None,
    namespace: Option[ActionNamespace] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ActionDeclaration = {
    import ActionDeclaration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ActionDeclaration
      .builder()
      .name(ActionName.unwrap(name): java.lang.String)
      .actionTypeId(actionTypeId.buildAwsValue())
      .optionallyWith(
        runOrder.map(value => ActionRunOrder.unwrap(value): Integer)
      )(_.runOrder)
      .optionallyWith(
        configuration.map(value =>
          value
            .map({ case (key, value) =>
              (ActionConfigurationKey.unwrap(
                key
              ): java.lang.String) -> (ActionConfigurationValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.configuration)
      .optionallyWith(
        outputArtifacts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputArtifacts)
      .optionallyWith(
        inputArtifacts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputArtifacts)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        region.map(value => AWSRegionName.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(
        namespace.map(value => ActionNamespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ActionDeclaration.ReadOnly =
    zio.aws.codepipeline.model.ActionDeclaration.wrap(buildAwsValue())
}
object ActionDeclaration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ActionDeclaration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ActionDeclaration =
      zio.aws.codepipeline.model.ActionDeclaration(
        name,
        actionTypeId.asEditable,
        runOrder.map(value => value),
        configuration.map(value => value),
        outputArtifacts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        inputArtifacts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        roleArn.map(value => value),
        region.map(value => value),
        namespace.map(value => value)
      )
    def name: ActionName
    def actionTypeId: zio.aws.codepipeline.model.ActionTypeId.ReadOnly
    def runOrder: Option[ActionRunOrder]
    def configuration
        : Option[Map[ActionConfigurationKey, ActionConfigurationValue]]
    def outputArtifacts
        : Option[List[zio.aws.codepipeline.model.OutputArtifact.ReadOnly]]
    def inputArtifacts
        : Option[List[zio.aws.codepipeline.model.InputArtifact.ReadOnly]]
    def roleArn: Option[RoleArn]
    def region: Option[AWSRegionName]
    def namespace: Option[ActionNamespace]
    def getName: ZIO[Any, Nothing, ActionName] = ZIO.succeed(name)
    def getActionTypeId
        : ZIO[Any, Nothing, zio.aws.codepipeline.model.ActionTypeId.ReadOnly] =
      ZIO.succeed(actionTypeId)
    def getRunOrder: ZIO[Any, AwsError, ActionRunOrder] =
      AwsError.unwrapOptionField("runOrder", runOrder)
    def getConfiguration: ZIO[Any, AwsError, Map[
      ActionConfigurationKey,
      ActionConfigurationValue
    ]] = AwsError.unwrapOptionField("configuration", configuration)
    def getOutputArtifacts: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.OutputArtifact.ReadOnly
    ]] = AwsError.unwrapOptionField("outputArtifacts", outputArtifacts)
    def getInputArtifacts: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.InputArtifact.ReadOnly
    ]] = AwsError.unwrapOptionField("inputArtifacts", inputArtifacts)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getRegion: ZIO[Any, AwsError, AWSRegionName] =
      AwsError.unwrapOptionField("region", region)
    def getNamespace: ZIO[Any, AwsError, ActionNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionDeclaration
  ) extends zio.aws.codepipeline.model.ActionDeclaration.ReadOnly {
    override val name: ActionName =
      zio.aws.codepipeline.model.primitives.ActionName(impl.name())
    override val actionTypeId
        : zio.aws.codepipeline.model.ActionTypeId.ReadOnly =
      zio.aws.codepipeline.model.ActionTypeId.wrap(impl.actionTypeId())
    override val runOrder: Option[ActionRunOrder] = scala
      .Option(impl.runOrder())
      .map(value => zio.aws.codepipeline.model.primitives.ActionRunOrder(value))
    override val configuration
        : Option[Map[ActionConfigurationKey, ActionConfigurationValue]] = scala
      .Option(impl.configuration())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.codepipeline.model.primitives.ActionConfigurationKey(
              key
            ) -> zio.aws.codepipeline.model.primitives
              .ActionConfigurationValue(value)
          })
          .toMap
      )
    override val outputArtifacts
        : Option[List[zio.aws.codepipeline.model.OutputArtifact.ReadOnly]] =
      scala
        .Option(impl.outputArtifacts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.OutputArtifact.wrap(item)
          }.toList
        )
    override val inputArtifacts
        : Option[List[zio.aws.codepipeline.model.InputArtifact.ReadOnly]] =
      scala
        .Option(impl.inputArtifacts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.InputArtifact.wrap(item)
          }.toList
        )
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.codepipeline.model.primitives.RoleArn(value))
    override val region: Option[AWSRegionName] = scala
      .Option(impl.region())
      .map(value => zio.aws.codepipeline.model.primitives.AWSRegionName(value))
    override val namespace: Option[ActionNamespace] = scala
      .Option(impl.namespace())
      .map(value =>
        zio.aws.codepipeline.model.primitives.ActionNamespace(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionDeclaration
  ): zio.aws.codepipeline.model.ActionDeclaration.ReadOnly = new Wrapper(impl)
}
