package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{Url, ActionName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ActionState(
    actionName: Option[ActionName] = None,
    currentRevision: Option[zio.aws.codepipeline.model.ActionRevision] = None,
    latestExecution: Option[zio.aws.codepipeline.model.ActionExecution] = None,
    entityUrl: Option[Url] = None,
    revisionUrl: Option[Url] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ActionState = {
    import ActionState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ActionState
      .builder()
      .optionallyWith(
        actionName.map(value => ActionName.unwrap(value): java.lang.String)
      )(_.actionName)
      .optionallyWith(currentRevision.map(value => value.buildAwsValue()))(
        _.currentRevision
      )
      .optionallyWith(latestExecution.map(value => value.buildAwsValue()))(
        _.latestExecution
      )
      .optionallyWith(
        entityUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.entityUrl)
      .optionallyWith(
        revisionUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.revisionUrl)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ActionState.ReadOnly =
    zio.aws.codepipeline.model.ActionState.wrap(buildAwsValue())
}
object ActionState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ActionState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ActionState =
      zio.aws.codepipeline.model.ActionState(
        actionName.map(value => value),
        currentRevision.map(value => value.asEditable),
        latestExecution.map(value => value.asEditable),
        entityUrl.map(value => value),
        revisionUrl.map(value => value)
      )
    def actionName: Option[ActionName]
    def currentRevision
        : Option[zio.aws.codepipeline.model.ActionRevision.ReadOnly]
    def latestExecution
        : Option[zio.aws.codepipeline.model.ActionExecution.ReadOnly]
    def entityUrl: Option[Url]
    def revisionUrl: Option[Url]
    def getActionName: ZIO[Any, AwsError, ActionName] =
      AwsError.unwrapOptionField("actionName", actionName)
    def getCurrentRevision: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.ActionRevision.ReadOnly
    ] = AwsError.unwrapOptionField("currentRevision", currentRevision)
    def getLatestExecution: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.ActionExecution.ReadOnly
    ] = AwsError.unwrapOptionField("latestExecution", latestExecution)
    def getEntityUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("entityUrl", entityUrl)
    def getRevisionUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("revisionUrl", revisionUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionState
  ) extends zio.aws.codepipeline.model.ActionState.ReadOnly {
    override val actionName: Option[ActionName] = scala
      .Option(impl.actionName())
      .map(value => zio.aws.codepipeline.model.primitives.ActionName(value))
    override val currentRevision
        : Option[zio.aws.codepipeline.model.ActionRevision.ReadOnly] = scala
      .Option(impl.currentRevision())
      .map(value => zio.aws.codepipeline.model.ActionRevision.wrap(value))
    override val latestExecution
        : Option[zio.aws.codepipeline.model.ActionExecution.ReadOnly] = scala
      .Option(impl.latestExecution())
      .map(value => zio.aws.codepipeline.model.ActionExecution.wrap(value))
    override val entityUrl: Option[Url] = scala
      .Option(impl.entityUrl())
      .map(value => zio.aws.codepipeline.model.primitives.Url(value))
    override val revisionUrl: Option[Url] = scala
      .Option(impl.revisionUrl())
      .map(value => zio.aws.codepipeline.model.primitives.Url(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionState
  ): zio.aws.codepipeline.model.ActionState.ReadOnly = new Wrapper(impl)
}
