package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  MaximumArtifactCount,
  MinimumArtifactCount
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ArtifactDetails(
    minimumCount: MinimumArtifactCount,
    maximumCount: MaximumArtifactCount
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ArtifactDetails = {
    import ArtifactDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ArtifactDetails
      .builder()
      .minimumCount(MinimumArtifactCount.unwrap(minimumCount): Integer)
      .maximumCount(MaximumArtifactCount.unwrap(maximumCount): Integer)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ArtifactDetails.ReadOnly =
    zio.aws.codepipeline.model.ArtifactDetails.wrap(buildAwsValue())
}
object ArtifactDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ArtifactDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ArtifactDetails =
      zio.aws.codepipeline.model.ArtifactDetails(minimumCount, maximumCount)
    def minimumCount: MinimumArtifactCount
    def maximumCount: MaximumArtifactCount
    def getMinimumCount: ZIO[Any, Nothing, MinimumArtifactCount] =
      ZIO.succeed(minimumCount)
    def getMaximumCount: ZIO[Any, Nothing, MaximumArtifactCount] =
      ZIO.succeed(maximumCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ArtifactDetails
  ) extends zio.aws.codepipeline.model.ArtifactDetails.ReadOnly {
    override val minimumCount: MinimumArtifactCount =
      zio.aws.codepipeline.model.primitives
        .MinimumArtifactCount(impl.minimumCount())
    override val maximumCount: MaximumArtifactCount =
      zio.aws.codepipeline.model.primitives
        .MaximumArtifactCount(impl.maximumCount())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ArtifactDetails
  ): zio.aws.codepipeline.model.ArtifactDetails.ReadOnly = new Wrapper(impl)
}
