package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.WebhookName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeregisterWebhookWithThirdPartyRequest(
    webhookName: Option[WebhookName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.DeregisterWebhookWithThirdPartyRequest = {
    import DeregisterWebhookWithThirdPartyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.DeregisterWebhookWithThirdPartyRequest
      .builder()
      .optionallyWith(
        webhookName.map(value => WebhookName.unwrap(value): java.lang.String)
      )(_.webhookName)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.DeregisterWebhookWithThirdPartyRequest.ReadOnly =
    zio.aws.codepipeline.model.DeregisterWebhookWithThirdPartyRequest
      .wrap(buildAwsValue())
}
object DeregisterWebhookWithThirdPartyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.DeregisterWebhookWithThirdPartyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codepipeline.model.DeregisterWebhookWithThirdPartyRequest =
      zio.aws.codepipeline.model
        .DeregisterWebhookWithThirdPartyRequest(webhookName.map(value => value))
    def webhookName: Option[WebhookName]
    def getWebhookName: ZIO[Any, AwsError, WebhookName] =
      AwsError.unwrapOptionField("webhookName", webhookName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.DeregisterWebhookWithThirdPartyRequest
  ) extends zio.aws.codepipeline.model.DeregisterWebhookWithThirdPartyRequest.ReadOnly {
    override val webhookName: Option[WebhookName] = scala
      .Option(impl.webhookName())
      .map(value => zio.aws.codepipeline.model.primitives.WebhookName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.DeregisterWebhookWithThirdPartyRequest
  ): zio.aws.codepipeline.model.DeregisterWebhookWithThirdPartyRequest.ReadOnly =
    new Wrapper(impl)
}
