package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.EncryptionKeyId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class EncryptionKey(
    id: EncryptionKeyId,
    `type`: zio.aws.codepipeline.model.EncryptionKeyType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.EncryptionKey = {
    import EncryptionKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.EncryptionKey
      .builder()
      .id(EncryptionKeyId.unwrap(id): java.lang.String)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.EncryptionKey.ReadOnly =
    zio.aws.codepipeline.model.EncryptionKey.wrap(buildAwsValue())
}
object EncryptionKey {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.EncryptionKey
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.EncryptionKey =
      zio.aws.codepipeline.model.EncryptionKey(id, `type`)
    def id: EncryptionKeyId
    def `type`: zio.aws.codepipeline.model.EncryptionKeyType
    def getId: ZIO[Any, Nothing, EncryptionKeyId] = ZIO.succeed(id)
    def getType
        : ZIO[Any, Nothing, zio.aws.codepipeline.model.EncryptionKeyType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.EncryptionKey
  ) extends zio.aws.codepipeline.model.EncryptionKey.ReadOnly {
    override val id: EncryptionKeyId =
      zio.aws.codepipeline.model.primitives.EncryptionKeyId(impl.id())
    override val `type`: zio.aws.codepipeline.model.EncryptionKeyType =
      zio.aws.codepipeline.model.EncryptionKeyType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.EncryptionKey
  ): zio.aws.codepipeline.model.EncryptionKey.ReadOnly = new Wrapper(impl)
}
