package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{Message, Code}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ErrorDetails(
    code: Option[Code] = None,
    message: Option[Message] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ErrorDetails = {
    import ErrorDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ErrorDetails
      .builder()
      .optionallyWith(code.map(value => Code.unwrap(value): java.lang.String))(
        _.code
      )
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ErrorDetails.ReadOnly =
    zio.aws.codepipeline.model.ErrorDetails.wrap(buildAwsValue())
}
object ErrorDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ErrorDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ErrorDetails =
      zio.aws.codepipeline.model
        .ErrorDetails(code.map(value => value), message.map(value => value))
    def code: Option[Code]
    def message: Option[Message]
    def getCode: ZIO[Any, AwsError, Code] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ErrorDetails
  ) extends zio.aws.codepipeline.model.ErrorDetails.ReadOnly {
    override val code: Option[Code] = scala
      .Option(impl.code())
      .map(value => zio.aws.codepipeline.model.primitives.Code(value))
    override val message: Option[Message] = scala
      .Option(impl.message())
      .map(value => zio.aws.codepipeline.model.primitives.Message(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ErrorDetails
  ): zio.aws.codepipeline.model.ErrorDetails.ReadOnly = new Wrapper(impl)
}
