package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetThirdPartyJobDetailsResponse(
    jobDetails: Option[zio.aws.codepipeline.model.ThirdPartyJobDetails] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.GetThirdPartyJobDetailsResponse = {
    import GetThirdPartyJobDetailsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.GetThirdPartyJobDetailsResponse
      .builder()
      .optionallyWith(jobDetails.map(value => value.buildAwsValue()))(
        _.jobDetails
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.GetThirdPartyJobDetailsResponse.ReadOnly =
    zio.aws.codepipeline.model.GetThirdPartyJobDetailsResponse
      .wrap(buildAwsValue())
}
object GetThirdPartyJobDetailsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.GetThirdPartyJobDetailsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.GetThirdPartyJobDetailsResponse =
      zio.aws.codepipeline.model.GetThirdPartyJobDetailsResponse(
        jobDetails.map(value => value.asEditable)
      )
    def jobDetails
        : Option[zio.aws.codepipeline.model.ThirdPartyJobDetails.ReadOnly]
    def getJobDetails: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.ThirdPartyJobDetails.ReadOnly
    ] = AwsError.unwrapOptionField("jobDetails", jobDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.GetThirdPartyJobDetailsResponse
  ) extends zio.aws.codepipeline.model.GetThirdPartyJobDetailsResponse.ReadOnly {
    override val jobDetails
        : Option[zio.aws.codepipeline.model.ThirdPartyJobDetails.ReadOnly] =
      scala
        .Option(impl.jobDetails())
        .map(value =>
          zio.aws.codepipeline.model.ThirdPartyJobDetails.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.GetThirdPartyJobDetailsResponse
  ): zio.aws.codepipeline.model.GetThirdPartyJobDetailsResponse.ReadOnly =
    new Wrapper(impl)
}
