package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{MaxPipelines, NextToken}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListPipelinesRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxPipelines] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ListPipelinesRequest = {
    import ListPipelinesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ListPipelinesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxPipelines.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ListPipelinesRequest.ReadOnly =
    zio.aws.codepipeline.model.ListPipelinesRequest.wrap(buildAwsValue())
}
object ListPipelinesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ListPipelinesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ListPipelinesRequest =
      zio.aws.codepipeline.model.ListPipelinesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxPipelines]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxPipelines] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ListPipelinesRequest
  ) extends zio.aws.codepipeline.model.ListPipelinesRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codepipeline.model.primitives.NextToken(value))
    override val maxResults: Option[MaxPipelines] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.codepipeline.model.primitives.MaxPipelines(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ListPipelinesRequest
  ): zio.aws.codepipeline.model.ListPipelinesRequest.ReadOnly = new Wrapper(
    impl
  )
}
